function pp=nb_probability(data, featureVals,bayes)
  
pp=zeros(1,size(data,1))+bayes.logPrior;
  
  for s=1:size(data,1)

      % This is the sample we are currently working with
      % its something like: 'xyytlfcbpersywwpwopnyp'
      x_sample = data(s,:);
      
      % inspect all dimensions of the sample
      for i=1:size(data,2)
        % returns all positions that 
        % have the same feature-value as the x_sample on dimension i
        ff = featureVals==x_sample(i); 
        
        % gets the p(x_i=x_k | Y1)
        pp(s) = pp(s) + bayes.pdm(ff,i);
      end
  end
end

