package contactbook;

public class ContactBook {

	public static final int MAX_CONTACTS = 50;

	private Contact[] contacts;
	private int counter,currentContact;
	private Contact[] contactsWithPrefix; //vector de contactos para guardar os contactos que comeam pelo prefixo indicado.
	private int counterWithPrefix, currentContactWithPrefix; //counter e currentContact para os mtodos dos prefixos
	
	// Construtor
	public ContactBook() {
		counter = 0;
		contacts = new Contact[MAX_CONTACTS];
		currentContact = -1;
		
		counterWithPrefix = 0;
		contactsWithPrefix = new Contact[MAX_CONTACTS];
		currentContactWithPrefix = -1;
	}
/** Mtodo que dado um nome de um contacto, procura e devolve a sua 
	posio no vector caso exista.
*/  
	private int searchIndex(String name) {
		int i = 0; // percurso pelos elementos 0..counter
		int result = -1;
		boolean find = false; // indicador de existncia
		while ((i < counter) && (!find))
			if (contacts[i].getName().equals(name))
				find = true;
			else
				i++;
		if (find)
			result = i;
		return result;
	}

	public void addContact(String name, int phone, String email) {
		if (searchIndex(name) == -1) {// novo contacto
			if (counter == contacts.length) { // vector cheio
				Contact tmp[] = new Contact[2 * contacts.length];
				int i = 0;
				while (i < counter) {
					tmp[i] = contacts[i];
					i++;
				}
				contacts = tmp;
			}
			contacts[counter] = new Contact(name, phone, email);
			counter++;
		}
	}

	public void deleteContact(String name) {
		int index = searchIndex(name);
		if (index != -1) { // contacto existente
			int i = index;
			while (i < counter - 1) {
				contacts[i] = contacts[i + 1];
				i++;
			}
			counter--;
		}
	}

	public void setEmail(String name, String email){
		int pos= searchIndex(name);
		if(pos!= -1) 						// contacto existe
			contacts[pos].setEmail(email);
	}
	
	public void setPhone(String name, int phone){
		int pos= searchIndex(name);
		if(pos!= -1) 						// contacto existe
			contacts[pos].setPhone(phone);
	}
	
	public int getPhone(String name){
		return contacts[searchIndex(name)].getPhone();
	}
	
	public String getEmail(String name){
		return contacts[searchIndex(name)].getEmail();
	}
	
	public boolean hasContact(String name){
		return (searchIndex(name)!=-1 );
	}
	

	
	public void initializeIterator(){
		if (counter > 0)
			currentContact = 0;
		else 
			currentContact = -1;
	}
	
	public boolean hasNext(){
		return((currentContact >= 0 ) &&(currentContact < counter));
	}
	
	public Contact next(){
		Contact contact = null;
		if(this.hasNext())
			contact = contacts[currentContact++];
		return contact;
	}
	
//Mtodo auxiliar que permite percorrer o vector principal (contacts) e guardar noutro vector (vector contactsWithPrefix) aqueles cujo nome comea pelo prefixo indicado.
	private void filterContactsWithPrefix(String prefix) {
		int i = 0;
		for (i = 0; i < counter; i++){		// percurso pelos elementos 0..counter
			if (contacts[i].getName().startsWith(prefix))
				contactsWithPrefix[counterWithPrefix++] = contacts[i]; //passa para o vector dos contactos que contm o prefixo,o contacto cujo nome contm o prefixo introduzido.
		}					
	}
	
	//Mtodos initIteratorWithPrefix, hasNextWithPrefix e nextWithPrefix, ambos com a mesma estrutura dos mtodos initializeIterator, hasNext e next, respectivamente.
	
	public void initIteratorWithPrefix(String prefix){
		this.filterContactsWithPrefix(prefix); //Chamada do mtodo auxiliar
		if (counterWithPrefix > 0)
			currentContactWithPrefix = 0;
		else 
			currentContactWithPrefix = -1;
		
	}
	
	public boolean hasNextWithPrefix(){
		return((currentContactWithPrefix >= 0 ) && (currentContactWithPrefix < counterWithPrefix));
	}
	
	public Contact nextWithPrefix(){
		Contact contact = null;
		if(this.hasNextWithPrefix())
			contact = contactsWithPrefix[currentContactWithPrefix++];
		return contact;
	}
	
}
