package contactbook;

import java.util.Scanner;
import java.io.*;

public class Main {

	public static final String FILE = "contacts.txt";

	// Constantes que definem as mensagens de erro
	public static final String CONTACT_EXISTS = "Contact already exists.";
	public static final String CONTACT_ADDED = "Contact added.";

	public static void main(String[] args) throws FileNotFoundException {
		Scanner in = new Scanner(System.in);
		ContactBook cBook = new ContactBook(); // Cria um livro de
												// contactos(objecto)
		readContactBook(cBook, FILE);
		listAllContacts(cBook);
		System.out
				.println("Insira um nome/prefixo de um contacto que deseja procurar. ");
		String prefix = in.nextLine();
		listAllContactsWithPrefix(prefix, cBook);

	}

	public static void readContactBook(ContactBook cBook, String contactsFile)
			throws FileNotFoundException {
		System.out.println("Reading Contacts File...");
		FileReader file = new FileReader(contactsFile);
		Scanner fin = new Scanner(file);
		int cont = fin.nextInt();
		fin.nextLine();
		for (int i = 0; i < cont; i++) {
			addContact(fin, cBook);
		}
		fin.close();
	}

	private static void addContact(Scanner in, ContactBook cBook) {
		String name = "";
		String email = "";
		int phone = 0;
		name = in.nextLine();
		phone = in.nextInt();
		in.nextLine(); // Consome a linha (enter)
		email = in.nextLine();
		if (!cBook.hasContact(name)) { // Verifica se o contacto existe
			cBook.addContact(name, phone, email);
			System.out.println(CONTACT_ADDED);
		} else
			System.out.println(CONTACT_EXISTS);
	}
	
	// Listar todos os contactos na consola
	private static void listAllContacts(ContactBook cBook) {
		cBook.initializeIterator();
		while (cBook.hasNext()) {
			System.out.println(cBook.next().toString());
		}
	}
	
	
	//Mtodo iterador para listar os contactos cujo nome comea pelo prefixo indicado.
	// Apresenta a mesma estrutura do listAllContacts
	public static void listAllContactsWithPrefix(String prefix,
			ContactBook cBook) {
		cBook.initIteratorWithPrefix(prefix);
		while (cBook.hasNextWithPrefix()) {
			System.out.println(cBook.nextWithPrefix().toString());
		}
	}

}
