#include <stdio.h>
#include <string.h>
#include <math.h>

#ifndef TPC3_BYTEMAP_H
#include "tpc3_bytemap.h"
#endif

/* Global variables */
unsigned int max_bm_entries = -1;    // stores the number of entries for the
				     // current test session (commands T and S)
				     // if this was a filesystem, it would be
				     // stored in the superblock


/* Helper functions */

int bytemap_print_table(unsigned int max_entries) {
  int ercode;
  unsigned char bmap[DISK_BLOCK_SIZE];
  int left= max_entries, entry= 0;

  // read in the bytemap
  ercode = disk_ops.read(BYTEMAP_OFFSET, bmap);
  if (ercode < 0) return ercode;

// **** DO NOT FORGET TO COMMENT THE NEXT LINE when submitting to Mooshak
  //printf("Printing the bytemap ----------\n");
  // prints 16 entries per line
  while (left) {
    if ( (entry+1)%16 ) printf("%u ", bmap[entry]);
    else printf("%u\n", bmap[entry]);
    left--; entry++;
  }
  if ( entry%16 ) printf("\n"); // last NL for general case

  return 0;
}


/* bytemap operations */

static int bytemap_allocate(unsigned int entry) {
  int ercode;
  unsigned char bmap[DISK_BLOCK_SIZE];

  if (entry >= max_bm_entries) return -EFBIG;

  ercode = disk_ops.read(BYTEMAP_OFFSET, bmap);
  if (ercode < 0) return ercode;
 
  if (bmap[entry] == 1) return -EBUSY; // already set to 1
  else bmap[entry]= 1;

  ercode = disk_ops.write(BYTEMAP_OFFSET, bmap);
  if (ercode < 0) return ercode;
  
  return 0;
}

static int bytemap_deallocate(unsigned int entry) {
  int ercode;
  unsigned char bmap[DISK_BLOCK_SIZE];

  if (entry >= max_bm_entries) return -EFBIG;

  ercode = disk_ops.read(BYTEMAP_OFFSET, bmap);
  if (ercode < 0) return ercode;
  
  if (bmap[entry] == 0) return -EINVAL; // already set to 0
  else bmap[entry]= 0;

  ercode = disk_ops.write(BYTEMAP_OFFSET, bmap);
  if (ercode < 0) return ercode;
  
  return entry;
}

static int bytemap_getfree() {
  int ercode;
  int entriesLeft= max_bm_entries;
  int entry= -ENOSPC;
  unsigned char bmap[DISK_BLOCK_SIZE];

  ercode = disk_ops.read(BYTEMAP_OFFSET, bmap);
  if (ercode < 0) return ercode;
  
  int i;
  for(i = 0; i < entriesLeft; i++)
  	if (bmap[i] == 0) { // when finds first free entry index
  		entry = i; // sets return entry to index
  		break; // and stops
  	}

  return entry;
}

struct bytemap_operations bmap_ops= {
	.allocate= bytemap_allocate,
	.deallocate= bytemap_deallocate,
	.getfree= bytemap_getfree
};
