package searchalgorithm;

import java.util.*;

import motion.AnimatedSearch;
import motion.RoverState;

import searchproblem.InformedSearchProblem;

/**
 * @author Ricardo Cruz Nr 34951
 * @author Ricardo Gaspar Nr 42038
 * @author Lus Silva Nr 34535 Docente: Francisco Azevedo P4
 */
public class AStarSearch implements SearchAlgorithm {
	private boolean done = false;
	private InformedSearchProblem problem;
	private Node goal;
	private Queue<Node> frontier;
	private int expansions;
	private int generated;
	private Map<Node, Node> explored;
	private long time; // adicionado para medir o tempo

	/**
	 * Initializes the search variables and creates a frontier based on a
	 * priority queue
	 * 
	 * @param problem
	 *            Problem with an heuristic function associated
	 */
	public AStarSearch(InformedSearchProblem p) {
		this.problem = p;
		goal = null;
		expansions = 0;
		generated = 0;

		frontier = new PriorityQueue<Node>(11, new Comparator<Node>() {
			public int compare(Node o1, Node o2) {
				if (o1.getPathCost() + problem.heuristic(o1) > o2.getPathCost()
						+ problem.heuristic(o2))
					return 1;
				else if (o1.getPathCost() + problem.heuristic(o1) < o2
						.getPathCost() + problem.heuristic(o2))
					return -1;
				else
					return 0;
			}
		});

	}

	@Override
	public Node searchSolution() {
		if (!done) {
			long startTime = System.nanoTime();
			goal = search();
			time = System.nanoTime() - startTime;
			done = true;
			frontier = null;
			problem = null;
		}
		return goal;
	}

	/**
	 * AStar Search algorithm. Finds and returns the goal node if it exists.
	 * 
	 * @return the goal node if it exists.
	 */
	private Node search() {
		frontier.clear();
		frontier.add(new Node(problem.getInitial()));
		generated++;

		// Initialization of explored
		explored = new HashMap<Node, Node>();

		for (;;) {
			if (frontier.isEmpty()) {
				return null;
			}
			Node n = frontier.remove();
			if (problem.goalTest(n.getState())) {
				return n;
			}
			// Adds the explored node to the explored list
			if (!explored.containsKey(n)) {
				explored.put(n, n);
//				AnimatedSearch.draw(((RoverState) n.getState()).getCoordX(),
//						((RoverState) n.getState()).getCoordY()); // testes
				expansions++;
				// Explores the current node and adds the nodes generated to the
				// frontier
				List<Node> children = n.Expand();
				generated += children.size();
				frontier.addAll(children);

			} else {
				// Replaces the old node in the explored list by the node with
				// higher f-value
				Node oldNode = explored.get(n);
				double oldFvalue = oldNode.getPathCost()
						+ problem.heuristic(oldNode);
				if (oldFvalue > (n.getPathCost() + problem.heuristic(n))) {
					explored.put(n, n);
//					AnimatedSearch.draw(
//							((RoverState) n.getState()).getCoordX(),
//							((RoverState) n.getState()).getCoordY()); // testes
					frontier.addAll(n.Expand());

				}
			}

		}

	}

	@Override
	public Map<String, Number> getMetrics() {
		Map<String, Number> metrics = new LinkedHashMap<String, Number>();

		metrics.put("Node Expansions", expansions);
		metrics.put("Nodes Generated", generated);
		metrics.put("Cost", goal.getPathCost());
		metrics.put("Runtime (s)", time / 1E9);
		return metrics;
	}

}
