package searchalgorithm;

import java.util.*;

import searchproblem.*;

/**
 * @author Ricardo Cruz Nr 34951
 * @author Ricardo Gaspar Nr 42038
 * @author Lus Silva Nr 34535
 * Docente: Francisco Azevedo	P4
 */
public class GraphSearch implements SearchAlgorithm {
	private boolean done = false;
	private SearchProblem problem;
	private Node goal;
	private Queue<Node> frontier;
	private int expansions;
	private int generated;
	private Map<Node, Node> explored;
	private long time; // adicionado para medir o tempo

	/**
	 * Initializes the search variables.
	 * 
	 * @param p
	 *            Problem to solve.
	 * @param q
	 *            Queue to store the nodes in the frontier.
	 */
	public GraphSearch(SearchProblem p, Queue<Node> q) {
		problem = p;
		goal = null;
		frontier = q;
		expansions = 0;
		generated = 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see searchalgorithm.SearchAlgorithm#searchSolution()
	 */
	public Node searchSolution() {
		if (!done) {
			long startTime = System.nanoTime();
			goal = search();
			time = System.nanoTime() - startTime;
			done = true;
			frontier = null;
			problem = null;
		}
		return goal;
	}

	/**
	 * Graph Search Algorithm. Finds and returns the goal node if it exists. Non-optimized for UniformCostSearch.
	 * 
	 * @return the goal node if it exists.
	 */
	private Node search() {
		frontier.clear();
		frontier.add(new Node(problem.getInitial()));
		generated++;

		// Initialization of explored
		explored = new HashMap<Node, Node>();

		for (;;) {
			if (frontier.isEmpty()) {
				return null;
			}
			Node n = frontier.remove();
			if (problem.goalTest(n.getState())) {
				return n;
			}
			// Add the explored node to the explored list
			explored.put(n, n);

			// Explores the current node and adds to the frontier
			expansions++;
			List<Node> children = n.Expand();
			generated += children.size();
			
			// adds the resulting nodes to the frontier only if not in the
			// frontier or explored set
			for (Node child : children) {
				if (!frontier.contains(child) && !explored.containsKey(child))
					frontier.add(child);
			}
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see searchalgorithm.SearchAlgorithm#getMetrics()
	 */
	public Map<String, Number> getMetrics() {
		Map<String, Number> metrics = new LinkedHashMap<String, Number>();

		metrics.put("Node Expansions", expansions);
		metrics.put("Nodes Generated", generated);
		metrics.put("Cost", goal.getPathCost());
		metrics.put("Runtime (s)", time / 1E9);
		return metrics;
	}

}
