
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;

import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;

/**
 * Aneex - Test 2
 */
public class DHA
{

    private static BigInteger g512 = new BigInteger(
            "153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7"
          + "749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b"
          + "410b7a0f12ca1cb9a428cc", 16);

    private static BigInteger p512 = new BigInteger(
            "9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd387"
          + "44d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94b"
          + "f0573bf047a3aca98cdf3b", 16);

    public static void main(
        String[]    args)
        throws Exception
    {
        DHParameterSpec             dhParams = new DHParameterSpec(p512, g512);

        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH", "BC");

        keyGen.initialize(dhParams);
       
        // This block models a principal A

        KeyAgreement aKeyAgree = KeyAgreement.getInstance("DH", "BC");
        KeyPair      aPair = keyGen.generateKeyPair();
        aKeyAgree.init(aPair.getPrivate());


        MessageDigest	hashA = MessageDigest.getInstance("SHA1", "BC");

        // This block models a principal A

        KeyAgreement bKeyAgree = KeyAgreement.getInstance("DH", "BC");
        KeyPair      bPair = keyGen.generateKeyPair();
        bKeyAgree.init(bPair.getPrivate());       


        MessageDigest	hashB = MessageDigest.getInstance("SHA1", "BC");

       
        // Then A generates the final agreement key       
        aKeyAgree.doPhase(bPair.getPublic(), true);
        byte[] aShared = hashA.digest(aKeyAgree.generateSecret());

        // Then B  generates the final agreement key              
        bKeyAgree.doPhase(aPair.getPublic(), true);
        byte[] bShared = hashB.digest(bKeyAgree.generateSecret());

        System.out.println("Key computed by A:" + UtilsDH.toHex(aShared)); // computed by A
        System.out.println("Key computed by B:" + UtilsDH.toHex(bShared)); // computed by B
    }
}
