import java.util.Scanner;

import stack.NoElementException;
import stack.Stack;
import stack.StackClass;

public class Main {
	private static final String PUSH = "PUSH";
	private static final String POP = "POP";
	private static final String POP_ALL = "POP-ALL";
	private static final String EXIT = "EXIT";

	private static final String POP_OK = "Pop do elemento %d efectuado com sucesso.\n";
	private static final String PUSH_OK = "Push do elemento %d efectuado com sucesso.\n";
	private static final String EMPTY_STACK = "Pilha vazia.";
	private static final String POP_ALL_OK = "Pop de todos os elementos da pilha:";
	private static final String EXITING = "Exiting.";
	
	public static void main(String[] args) {
		Stack<Integer> stack = new StackClass<Integer>();
		Scanner in = new Scanner(System.in);
		String cmd = in.next().toUpperCase();
		while (!cmd.equals(EXIT)) {
			switch (cmd) {
			case PUSH :
				push(in, stack);
				break;
			case POP :
				pop(in, stack);
				break;
			case POP_ALL : 
				popAll(in, stack);
			default: 
				break;
			}
			System.out.println();
			cmd = in.next().toUpperCase();
		}
		System.out.println(EXITING);
	}
	
	private static void push(Scanner in, Stack<Integer> stack) {
		int element = in.nextInt(); 
		in.nextLine();
		stack.push(element);
		System.out.printf(PUSH_OK,element);
	}

	private static void pop(Scanner in, Stack<Integer> stack) {
		try {
			int element = stack.pop();
			System.out.printf(POP_OK,element);
		}
		catch(NoElementException e) {
			System.out.println(EMPTY_STACK);
		}
	}

	private static void popAll(Scanner in, Stack<Integer> stack) {
		try {
			System.out.println(POP_ALL_OK);
			while (!stack.isEmpty())
				System.out.println(stack.pop());
		}
		catch(NoElementException e) {
			System.out.println(EMPTY_STACK);
		}
	}
}