package stack;

import array.Array;
import array.ArrayClass;

public class StackClass<E> implements Stack<E> {
	private static final int DEFAULT_SIZE = 10;
	
	Array<E> stack;
	
	/**
	 * Default stack constructor
	 */
	public StackClass() {
		stack = new ArrayClass<E>(DEFAULT_SIZE);
	}
	
	/**
	 * Constructor that defines a stack with initial dimension of <code>capacity</code> 
	 * @param capacity initial dimension of the stack
	 */
	public StackClass(int capacity) {
		stack = new ArrayClass<E>(capacity);
	}
	
	@Override
	public void push(E elem) {
		stack.insertLast(elem);
	}

	@Override
	public E pop() throws NoElementException{
		if (this.isEmpty()) throw new NoElementException();
		
		return stack.removeLast();
	}
	
	@Override
	public boolean isEmpty() {
		return stack.size() == 0;
	}

	@Override
	public int size() {
		return stack.size();
	}
}
