package stack;

public interface Stack<E> {
	
	/**
	 * Pushes element <code>elem</code> into the top of the stack
	 * @param elem
	 */
	void push(E elem);
	
	/**
	 * Pops an element <code>elem</code> from the top of the stack
	 * @throws NoElementException if isEmpty()
	 * @returns the element on the top of the stack
	 */
	E pop() throws NoElementException;
	
	/**
	 * Checks if the stack is empty
	 * @return true is the stack is empty, or false otherwise
	 */
	boolean isEmpty();
	
	/**
	 * Determines the number of elements on the stack
	 * @return number of elements in the stack
	 */
	int size();
}
