public enum Command {
	ADD_CONTACT		("AC","Add contact"),
	REMOVE_CONTACT	("RC","Remove contact"),
	GET_PHONE		("GP","Get phone"),
	GET_EMAIL		("GE","Get email"),
	SET_PHONE		("SP","Set phone"),
	SET_EMAIL		("SE","Set email"),
	LIST_CONTACTS	("LC","List contacts"),
	GET_NAME			("GN","Get name"),
	EQUAL_PHONE		("EP","Equal phones"),
	QUIT				("Q","Quit"),
	HELP				("H","Help");

	private String name;
	private String description;

	private Command(String name,String description) {
		this.name = name;
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public String toString() {
		return description;
	}

	public static Command getValue(String command) {
		for (Command c : Command.values()) {
			if (c.getName().equalsIgnoreCase(command)) {
				return c;
			}
		}
		return null;
	}
}