import java.util.Scanner;

import array.Iterator;
import cbook.*;

public class Main {
	//Constantes que definem as mensagens para o utilizador
	private static final String CONTACT_EXISTS = "Contact already exists.";
	private static final String NAME_NOT_EXIST = "Contact does not exist.";
	private static final String CONTACT_ADDED = "Contact added.";
	private static final String CONTACT_REMOVED = "Contact removed.";
	private static final String CONTACT_UPDATED = "Contact updated.";
	private static final String BOOK_EMPTY = "Contact book empty.";

	public static void main(String[] args) {   
		Scanner in = new Scanner(System.in);
		ContactBook cBook = new ContactBookClass();
		Command comm = getCommand(in);

		while (!comm.equals(Command.QUIT)){
			switch (comm) {
			case ADD_CONTACT: addContact(in,cBook); break;
			case REMOVE_CONTACT: deleteContact(in,cBook); break;
			case GET_PHONE: getPhone(in,cBook); break;
			case GET_EMAIL: getEmail(in,cBook); break;
			case SET_PHONE: setPhone(in,cBook); break;
			case SET_EMAIL: setEmail(in,cBook); break;
			case LIST_CONTACTS: listAllContacts(cBook); break;
			case HELP: help(); break;
			default:
			}
			System.out.println();
			comm = getCommand(in);
		}
		System.out.println("Goodbye!");
		System.out.println();
		in.close();
	}
	
	private static Command getCommand(Scanner input) {
		Command c = Command.getValue(input.nextLine());
		if (c == null) return Command.QUIT;
		else return c;
	}
	
	private static void help() {
		for(Command c : Command.values())
			System.out.println(c);
	}

	private static void addContact(Scanner in, ContactBook cBook) {
		String name, email;
		int phone;

		name = in.nextLine();
		phone = in.nextInt(); in.nextLine();
		email = in.nextLine();
		if (!cBook.hasContact(name)) {
			cBook.addContact(name, phone, email);
			System.out.println(CONTACT_ADDED);
		}
		else System.out.println(CONTACT_EXISTS);
	}

	private static void deleteContact(Scanner in, ContactBook cBook) {
		String name;
		name = in.nextLine();
		if (cBook.hasContact(name)) {
			cBook.deleteContact(name);
			System.out.println(CONTACT_REMOVED);
		}
		else System.out.println(NAME_NOT_EXIST);
	}

	private static void getPhone(Scanner in, ContactBook cBook) {
		String name;
		name = in.nextLine();
		if (cBook.hasContact(name)) {
			System.out.println(cBook.getPhone(name));
		}
		else System.out.println(NAME_NOT_EXIST);
	}

	private static void getEmail(Scanner in, ContactBook cBook) {
		String name;
		name = in.nextLine();
		if (cBook.hasContact(name)) {
			System.out.println(cBook.getEmail(name));
		}
		else System.out.println(NAME_NOT_EXIST);
	}

	private static void setPhone(Scanner in, ContactBook cBook) {
		String name;
		int phone;
		name = in.nextLine();
		phone = in.nextInt(); in.nextLine();
		if (cBook.hasContact(name)) {
			cBook.setPhone(name,phone);
			System.out.println(CONTACT_UPDATED);
		}
		else System.out.println(NAME_NOT_EXIST);
	}

	private static void setEmail(Scanner in, ContactBook cBook) {
		String name;
		String email;
		name = in.nextLine();
		email = in.nextLine();
		if (cBook.hasContact(name)) {
			cBook.setEmail(name,email);
			System.out.println(CONTACT_UPDATED);
		}
		else System.out.println(NAME_NOT_EXIST);
	}

	private static void listAllContacts(ContactBook cBook) {
		if (cBook.getNumberOfContacts() != 0) {
			Iterator<Contact> it = cBook.listContacts();
			while( it.hasNext() ) {
				Contact c = it.next();
				System.out.println(c.getName() + "; " + c.getEmail() + "; " + c.getPhone());
			}
		}
		else System.out.println(BOOK_EMPTY);
	}
}
