---
layout: page
title: Recommended Books
---

Here are the books that helped me out the most when learning MPI. Most of these are written by the primary designers of the Message Passing Interface. Some also include tutorials on how to use OpenMP with MPI. The very first book is a compilation of the beginner tutorials of this site as well and helps support mpitutorial.com.

> **Disclaimer** - The links on this page are Amazon affiliate links. If you click on the links and purchase books, the primary author (Wes Kendall) receives commission.

## Beginning MPI (An Introduction in C)
This book is a compilation of all of the beginner tutorials on this site. It goes over everything from installing MPI on an Amazon EC2 cluster to the basics of sending and receiving with MPI to performing collective operations and reductions. If you have enjoyed the tutorials on this site and wish to have a copy of it in book format (while also supporting mpitutorial.com), then [click here for more info](http://www.amazon.com/gp/product/B00HM7O0M8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=B00HM7O0M8&linkCode=as2&tag=softengiintet-20).

[![Beginning MPI - An Introduction in C](http://ws.assoc-amazon.com/widgets/q?_encoding=UTF8&Format=_SL110_&ASIN=B00HM7O0M8&MarketPlace=US&ID=AsinImage&WS=1&tag=softengiintet-20&ServiceVersion=20070822)](http://www.amazon.com/gp/product/B00HM7O0M8/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=B00HM7O0M8&linkCode=as2&tag=softengiintet-20)

## Parallel Programming with MPI
My personal favorite MPI book. The book gives a good overview of parallel computing before delving into all the various topics of MPI programming. It goes into detail about almost every essential MPI routine, and then it provides examples of parallel programs such as matrix multiplication and sorting. The end of the book discusses libraries and debugging routines. [Click here for more info](http://www.amazon.com/gp/product/1558603395/ref=as_li_qf_sp_asin_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=1558603395).

[![Parallel Programming with MPI](http://ws.assoc-amazon.com/widgets/q?_encoding=UTF8&Format=_SL110_&ASIN=1558603395&MarketPlace=US&ID=AsinImage&WS=1&tag=softengiintet-20&ServiceVersion=20070822)](http://www.amazon.com/gp/product/1558603395/ref=as_li_qf_sp_asin_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=1558603395)

## Using MPI - 2nd Edition
This is a more up-to-date book than the previous, but it mostly focuses on the newer and more advanced MPI routines in the second MPI standard. These include parallel I/O, remote memory access, and dynamic process management. The book also discusses using MPI with threads. This is a must have for advanced MPI development. [Click here for more info](http://www.amazon.com/gp/product/0262571323/ref=as_li_tf_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=0262571323).

[![Using MPI - 2nd Edition](http://ws.assoc-amazon.com/widgets/q?_encoding=UTF8&Format=_SL110_&ASIN=0262571323&MarketPlace=US&ID=AsinImage&WS=1&tag=softengiintet-20&ServiceVersion=20070822)](http://www.amazon.com/gp/product/0262571323/ref=as_li_tf_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=0262571323)

## Parallel Programming in C with MPI and OpenMP
This book is a bit older than the others, but it is still a classic. One strong point of this book is the huge amount of parallel programming examples, along with its focus on MPI and OpenMP. Many parallel programs are discussed in great detail, including matrix multiplication, fast fourier transforms, sorting, and combinatorial searching. [Click here for more info](http://www.amazon.com/gp/product/0071232656/ref=as_li_tf_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=0071232656).

[![Parallel Programming in C with MPI and OpenMP](http://ws.assoc-amazon.com/widgets/q?_encoding=UTF8&Format=_SL110_&ASIN=0071232656&MarketPlace=US&ID=AsinImage&WS=1&tag=softengiintet-20&ServiceVersion=20070822)](http://www.amazon.com/gp/product/0071232656/ref=as_li_tf_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=0071232656)

## MPI: The Complete Reference
A complete reference guide to MPI one and two. The book does not necessarily teach MPI, but it provides a great reference and complete descriptions of every single function. One advantage of this book is that it includes Fortran routines as well as C routines. [Click here for more info](http://www.amazon.com/gp/product/0262692163/ref=as_li_tf_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=0262692163).

[![MPI: The Complete Reference](http://ws.assoc-amazon.com/widgets/q?_encoding=UTF8&Format=_SL110_&ASIN=0262692163&MarketPlace=US&ID=AsinImage&WS=1&tag=softengiintet-20&ServiceVersion=20070822)](http://www.amazon.com/gp/product/0262692163/ref=as_li_tf_il?ie=UTF8&tag=softengiintet-20&linkCode=as2&camp=217145&creative=399377&creativeASIN=0262692163)

![](http://www.assoc-amazon.com/e/ir?t=softengiintet-20&l=as2&o=1&a=0262692163&camp=217145&creative=399377)