function plotreport(train,test,coefs,s)
%plots and reports
  predicted=polyval(coefs,test(:,1));
  errTest=mean((test(:,2)-predicted).^2);

  predicted=polyval(coefs,train(:,1));
  errTrain=mean((train(:,2)-predicted).^2);

  fprintf('%s: %i with train error %f and test error %f\n',...
    s,length(coefs),errTrain,errTest);
  hold on
  plot(test(:,1),test(:,2),'xr');
  plot(train(:,1),train(:,2),'ob');
  dt=[train;test];
  xs=linspace(min(dt(:,1)),max(dt(:,1)),100);
  ys=polyval(coefs,xs);
  plot(xs,ys,'-r');
  legend('Test data', 'Train data', 'Fitted polynomial');
  hold off
end
