clear all
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  script starts here
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% global variable for regularization
% copy training set here to use in totalerror function
global globalTrainingSet

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uncomment to generate points
%sinpoints=sinxpi(40,0,1,0.1);
%save sin.dat sinpoints
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sinpoints = importdata('sin_mat.dat');

[test,train]=randsplit(sinpoints,10);
maxPoly=8


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% leave one out cross-validation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for f=1:maxPoly
  errs(f)=loocvpoly(f,train);
end

%plot the errors for polynomials 1-12
subplot(2,3,1)
plot(errs);

[m,ix]=min(errs);

coefsLooCV=polyfit(train(:,1),train(:,2),ix);
%coefsLooCV=coefs(end:-1:1); %this is necessary because coeficients are in inverse order
subplot(2,3,2)
plotreport(train,test,coefsLooCV,'Best polynomial loocv');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% residual plot, for kfold (for others it's the same)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(2,3,3)
testRs=polyval(coefsLooCV,test(:,1))-test(:,2);
trainRs=polyval(coefsLooCV,train(:,1))-train(:,2);
plot(test(:,1),testRs,'xr');
plot(train(:,1),trainRs,'ob');
ylabel('Residuals');
title('Residuals - 5 fold CV');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 5-fold cross validation, same train and test set
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

kfolds=kfoldsplit(train,5);

for f=1:maxPoly
  errs(f)=kfoldcv(f,kfolds);
end
subplot(2,3,4)
plot(errs);
[m,ix]=min(errs);
 
coefsKFold=polyfit(train(:,1),train(:,2),ix);
subplot(2,3,5)
plotreport(train,test,coefsKFold,'Best polynomial kfold')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% residual plot, for kfold (for others it's the same)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(2,3,6)
testRs=polyval(coefsKFold,test(:,1))-test(:,2);
trainRs=polyval(coefsKFold,train(:,1))-train(:,2);
plot(test(:,1),testRs,'xr');
plot(train(:,1),trainRs,'ob');
ylabel('Residuals');
title('Residuals - 5 fold CV');

print -dtiff -r200 figureCV.tiff
