clear all
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  script starts here
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% global variable for regularization
% copy training set here to use in totalerror function
global globalTrainingSet


turtles=importdata('turtles_mat.dat')

[test,train]=randsplit(turtles,6);
maxPoly=8


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% leave one out cross-validation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for f=1:maxPoly
  errs(f)=loocvpoly(f,train);
end

%plot the errors for polynomials 1-12
subplot(2,2,1);
semilogy(errs);
[m,ix]=min(errs);
xlabel('Polynomial degree');
title('CV-Error');

subplot(2,2,2);
coefsLooCV=polyfit(train(:,1),train(:,2),ix);
plotreport(train,test,coefsLooCV,'Best polynomial loocv');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% residual plot, for loocv
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(2,2,3);
hold on
testRs=polyval(coefsLooCV,test(:,1))-test(:,2);
trainRs=polyval(coefsLooCV,train(:,1))-train(:,2);
plot(test(:,1),testRs,'xr');
plot(train(:,1),trainRs,'ob');
title('Residuals');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% residual histogram, for loocv
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
allRs=[testRs;trainRs];
subplot(2,2,4);
edges=linspace(min(allRs),max(allRs),10);
bins=histc(allRs,edges);
bar(bins)
title('Residuals histogram');
print -dtiff -r200 figureTurtles.tiff
