import schoolSystem.*;

import java.util.Scanner;
import java.io.*;
import dataStructures.*;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 * 
 *         Classe Main - programa principal.
 */
public class Main {

	// Mensagens de sucesso e erro.
	private static final String DATABASE = "database.txt";
	private static final String INSERT_CARD_SUCCESS = "Insercao de cartao com sucesso.\n";
	private static final String CARD_EXISTS = "Existencia de cartao referido.\n";
	private static final String REMOVE_CARD_SUCCESS = "Remocao de cartao com sucesso.\n";
	private static final String CARD_INEXISTENT = "Inexistencia de cartao referido.\n";
	private static final String INCREASE_CARD_BALANCE_SUCCESS = "Carregamento efetuado.\n";
	private static final String INSERT_PRODUCT_SUCCESS = "Insercao de produto com sucesso.\n";
	private static final String PRODUCT_EXISTS = "Existencia de produto referido.\n";
	private static final String PRODUCT_NAME_EXISTS = "Existencia de nome de produto referido.\n";
	private static final String PRODUCT_INEXISTENT = "Inexistencia de produto referido.\n";
	private static final String CARD_HAS_NO_TRANSACTIONS = "Cartao nao tem movimentos.\n";
	private static final String CARD_HAS_NO_FAVOURITES = "Cartao nao tem favoritos.\n";
	private static final String PURCHASE_PRODUCT_SUCCESS = "Compra efetuada.\n";
	private static final String INSUFICIENT_BALANCE = "Saldo insuficiente.\n";
	private static final String ADD_FAVOURITE_PRODUCT_SUCCESS = "Adicao de favorito a cartao com sucesso.\n";
	private static final String FAVOURITE_PRODUCT_EXISTS = "Produto ja e favorito do cartao.\n";
	private static final String FAVOURITE_PRODUCT_INEXISTENT = "Produto referido nao e favorito do cartao.\n";
	private static final String REMOVE_FAVOURITE_SUCCESS = "Remocao de favorito de cartao com sucesso.\n";
	private static final String CHANGE_MONTH_SUCCESS = "Mudanca de mes executada.\n";
	private static final String LIST_PRODUCTS_INEXISTENCE = "Inexistencia de Produtos.\n";

	public enum IOCommands {

		INSERT_CARD("IC"), REMOVE_CARD("RC"), GET_CARD_DATA("CC"), INCREASE_BALANCE(
				"CS"), INSERT_PRODUCT("IP"), GET_PRODUCT("CP"), PURCHASE_PRODUCT(
				"AP"), ADD_FAVOURITE_PRODUCT("FP"), PURCHASE_FAVOURITE_PRODUCT(
				"AF"), REMOVE_FAVOURITE_PRODUCT("RF"), LIST_FAVOURITE_PRODUCTS(
				"LF"), LIST_TRANSACTIONS("LM"), CHANGE_MONTH("MM"), LIST_PRODUCTS(
				"LP");

		private String command;

		IOCommands(String command) {
			this.command = command;
		}

		public String toString() {
			return this.command;
		}
	}

	public static void main(String[] args) {

		Scanner in = new Scanner(System.in);
		String cmd;
		SchoolSystem ss = readAsObject(DATABASE);

		if (ss == null)
			ss = new SchoolSystemClass();

		while (in.hasNext()) {

			cmd = in.next();

			if (isCommand(cmd, IOCommands.INSERT_CARD)) {
				insertCard(ss, in);
			} else if (isCommand(cmd, IOCommands.REMOVE_CARD)) {
				removeCard(ss, in);
			} else if (isCommand(cmd, IOCommands.GET_CARD_DATA)) {
				getCard(ss, in);
			} else if (isCommand(cmd, IOCommands.INCREASE_BALANCE)) {
				increaseCardBalance(ss, in);
			} else if (isCommand(cmd, IOCommands.INSERT_PRODUCT)) {
				insertProduct(ss, in);
			} else if (isCommand(cmd, IOCommands.GET_PRODUCT)) {
				getProduct(ss, in);
			} else if (isCommand(cmd, IOCommands.PURCHASE_PRODUCT)) {
				purchaseProduct(ss, in);
			} else if (isCommand(cmd, IOCommands.ADD_FAVOURITE_PRODUCT)) {
				addFavouriteProduct(ss, in);
			} else if (isCommand(cmd, IOCommands.PURCHASE_FAVOURITE_PRODUCT)) {
				purchaseFavouriteProduct(ss, in);
			} else if (isCommand(cmd, IOCommands.REMOVE_FAVOURITE_PRODUCT)) {
				removeFavouriteProduct(ss, in);
			} else if (isCommand(cmd, IOCommands.LIST_FAVOURITE_PRODUCTS)) {
				listFavouriteProducts(ss, in);
			} else if (isCommand(cmd, IOCommands.LIST_TRANSACTIONS)) {
				listTransactions(ss, in);
			} else if (isCommand(cmd, IOCommands.CHANGE_MONTH)) {
				changeMonth(ss, in);
			} else if (isCommand(cmd, IOCommands.LIST_PRODUCTS)) {
				listProducts(ss, in);
			}
		}
		storeAsObject(ss, DATABASE);

	}

	/**
	 * Verifica se o comando  vlido.
	 * 
	 * @param str
	 *            Comando lido da consola.
	 * @param cmd
	 *            Comando a comparar.
	 * @return Devolve <code>true</code> caso <code>str</code> e
	 *         <code>cmd</code> sejam iguais. Caso contrrio devolve
	 *         <code>false</code>.
	 */
	private static boolean isCommand(String str, IOCommands cmd) {
		return str.equalsIgnoreCase(cmd.toString());
	}

	/**
	 * L os dados de entrada e insere um carto no sistema.Como resultado
	 * imprime uma mensagem sobre o sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void insertCard(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		String studentName = in.nextLine().trim();
		int balance = in.nextInt();
		String studentClass = in.nextLine().trim();
		String address = in.nextLine();
		String contact = in.nextLine();
		in.nextLine();
		try {
			ss.insertCard(cardCode, studentName, balance, studentClass,
					address, contact);
			System.out.println(INSERT_CARD_SUCCESS);
		} catch (CardAlreadyExistsException e) {
			System.out.println(CARD_EXISTS);
		}
	}

	/**
	 * L os dados de entrada e devolve um carto existente no sistema. Como
	 * resultado imprime uma mensagem sobre o sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void getCard(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		in.nextLine();
		in.nextLine();
		Card c;
		try {
			c = ss.getCard(cardCode);
			System.out.println(c.toString());
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		}

	}

	/**
	 * L os dados de entrada e remove um carto existente no sistema. Como
	 * resultado imprime uma mensagem sobre o sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void removeCard(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		in.nextLine(); // consome o resto da linha
		in.nextLine();
		try {
			ss.removeCard(cardCode);
			System.out.println(REMOVE_CARD_SUCCESS);
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		}
	}

	/**
	 * L os dados de entrada e aumenta o saldo de um carto existente no
	 * sistema. Como resultado imprime uma mensagem sobre o sucesso ou insucesso
	 * da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void increaseCardBalance(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		int amount = in.nextInt();
		in.nextLine();
		in.nextLine();
		try {
			ss.increaseCardBalance(cardCode, amount);
			System.out.println(INCREASE_CARD_BALANCE_SUCCESS);
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		}
	}

	/**
	 * L os dados de entrada e insere um produto inexistente no sistema. Como
	 * resultado imprime uma mensagem sobre o sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void insertProduct(SchoolSystem ss, Scanner in) {

		int productCode = in.nextInt();
		String productName = in.nextLine().trim();
		int productPrice = in.nextInt();
		in.nextLine();
		in.nextLine();
		try {
			ss.insertProduct(productCode, productName, productPrice);
			System.out.println(INSERT_PRODUCT_SUCCESS);
		} catch (ProductAlreadyExistsException e) {
			System.out.println(PRODUCT_EXISTS);
		} catch (ProductNameAlreadyExistsException e) {
			System.out.println(PRODUCT_NAME_EXISTS);
		}

	}

	/**
	 * L os dados de entrada e devolve um produto existente no sistema. Como
	 * resultado imprime uma mensagem sobre o sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void getProduct(SchoolSystem ss, Scanner in) {

		int productCode = in.nextInt();
		in.nextLine();
		in.nextLine();
		Product product;
		try {
			product = ss.getProduct(productCode);
			System.out.println(product.toString());
		} catch (ProductInexistenceException e) {
			System.out.println(PRODUCT_INEXISTENT);
		}

	}

	/**
	 * L os dados de entrada e lista todos os produtos existentes no sistema.
	 * Como resultado imprime uma mensagem sobre o sucesso ou insucesso da
	 * operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void listProducts(SchoolSystem ss, Scanner in) {
		in.nextLine();
		in.nextLine();
		try {
			Iterator<Entry<String, Product>> it = ss.listProducts();
			Product product;
			while (it.hasNext()) {
				product = it.next().getValue();
				System.out.println(product.getName() + " " + product.getCode()
						+ " " + product.getPrice() + " "
						+ product.getTotalSales());
			}
			System.out.println();
		} catch (ProductInexistenceException e) {
			System.out.println(LIST_PRODUCTS_INEXISTENCE);
		}
	}

	/**
	 * Muda o ms no sistema. Como resultado imprime uma mensagem de sucesso.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void changeMonth(SchoolSystem ss, Scanner in) {
		ss.changeMonth();
		System.out.println(CHANGE_MONTH_SUCCESS);

	}

	/**
	 * L os dados de entrada e devolve uma lista de movimentos realizados por
	 * um carto existente no sistema. Como resultado imprime uma mensagem sobre
	 * o sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void listTransactions(SchoolSystem ss, Scanner in) {
		int cardCode = in.nextInt();
		in.nextLine();
		in.nextLine();
		Iterator<Transaction> it;
		try {
			it = ss.listTransactions(cardCode);
			it.rewind();
			while (it.hasNext()) {
				System.out.println(it.next().toString());
			}
			System.out.println();
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		} catch (CardWithoutTransactionsException e) {
			System.out.println(CARD_HAS_NO_TRANSACTIONS);
		}

	}

	/**
	 * L os dados de entrada e devolve uma lista de produtos favoritos de um um
	 * carto existente no sistema. Como resultado imprime uma mensagem sobre o
	 * sucesso ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void listFavouriteProducts(SchoolSystem ss, Scanner in) {
		int cardCode = in.nextInt();
		in.nextLine();
		in.nextLine();
		try {
			Iterator<Entry<String, Product>> it = ss.listFavouriteProducts(cardCode);
			Product favouriteProduct;
			while(it.hasNext()){
				favouriteProduct = it.next().getValue();
					System.out.println(favouriteProduct.getName() + " "
					+ favouriteProduct.getCode() + " "
					+ favouriteProduct.getPrice() + ".");
			}
			System.out.println();
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		} catch (CardWithoutFavouritesException e) {
			System.out.println(CARD_HAS_NO_FAVOURITES);
		}
	}

	/**
	 * L os dados de entrada e remove o produto favorito de um um carto
	 * existente no sistema. Como resultado imprime uma mensagem sobre o sucesso
	 * ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void removeFavouriteProduct(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		String productName = in.nextLine().trim();
		try {
			ss.removeFavouriteProduct(cardCode, productName);
			System.out.println(REMOVE_FAVOURITE_SUCCESS);
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		} catch (FavouriteProductInexistenceException e) {
			System.out.println(FAVOURITE_PRODUCT_INEXISTENT);
		}
	}

	/**
	 * L os dados de entrada e compra o produto favorito de um um carto
	 * existente no sistema. Como resultado imprime uma mensagem sobre o sucesso
	 * ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void purchaseFavouriteProduct(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		String productName = in.nextLine().trim();
		int totalItems = in.nextInt();
		in.nextLine();
		in.nextLine();
		try {
			ss.purchaseFavouriteProduct(cardCode, productName, totalItems);
			System.out.println(PURCHASE_PRODUCT_SUCCESS);
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		} catch (FavouriteProductInexistenceException e) {
			System.out.println(FAVOURITE_PRODUCT_INEXISTENT);
		} catch (InsufficientBalanceException e) {
			System.out.println(INSUFICIENT_BALANCE);
		}

	}

	/**
	 * L os dados de entrada e adiciona o produto aos favoritos de um um carto
	 * existente no sistema. Como resultado imprime uma mensagem sobre o sucesso
	 * ou insucesso da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void addFavouriteProduct(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		int productCode = in.nextInt();
		in.nextLine();
		in.nextLine();
		try {
			ss.addFavouriteProduct(cardCode, productCode);
			System.out.println(ADD_FAVOURITE_PRODUCT_SUCCESS);
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		} catch (ProductInexistenceException e) {
			System.out.println(PRODUCT_INEXISTENT);
		} catch (FavouriteProductAlreadyExistsException e) {
			System.out.println(FAVOURITE_PRODUCT_EXISTS);
		}

	}

	/**
	 * L os dados de entrada e compra o produto de um um carto existente no
	 * sistema. Como resultado imprime uma mensagem sobre o sucesso ou insucesso
	 * da operao.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param in
	 *            Canal de dados de entrada.
	 */
	private static void purchaseProduct(SchoolSystem ss, Scanner in) {

		int cardCode = in.nextInt();
		int productCode = in.nextInt();
		int totalItems = in.nextInt();
		in.nextLine();
		in.nextLine();
		try {
			ss.purchaseProduct(cardCode, productCode, totalItems);
			System.out.println(PURCHASE_PRODUCT_SUCCESS);
		} catch (CardInexistenceException e) {
			System.out.println(CARD_INEXISTENT);
		} catch (ProductInexistenceException e) {
			System.out.println(PRODUCT_INEXISTENT);
		} catch (InsufficientBalanceException e) {
			System.out.println(INSUFICIENT_BALANCE);
		}

	}

	/**
	 * Carrega um ficheiro com estado do sistema a partir de um nome.
	 * 
	 * @param filename
	 *            Nome do ficheiro a ler.
	 * @return Objecto com o estado do sistema.
	 */
	private static SchoolSystem readAsObject(String filename) {
		try {
			ObjectInputStream file = new ObjectInputStream(new FileInputStream(
					filename));
			SchoolSystem ss = (SchoolSystem) file.readObject();
			file.close();
			return ss;
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		} catch (ClassNotFoundException e) {
		}
		return null;
	}

	/**
	 * Guarda o estado actual do sistema num ficheiro com o nome especificado.
	 * 
	 * @param ss
	 *            Objecto SchoolSystem que representa o sistema escolar.
	 * @param filename
	 *            Nome do ficheiro a guardar.
	 */
	private static void storeAsObject(SchoolSystem ss, String filename) {

		try {
			ObjectOutputStream file = new ObjectOutputStream(
					new FileOutputStream(filename));

			file.writeObject(ss);
			file.flush();
			file.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
