package dataStructures;

import java.io.Serializable;

public interface Dictionary<K, V> extends Serializable {

	/**
	 * Returns <code>true</code> if the dictionary contains no entries.
	 * 
	 * @return <code>true</code> if the dictionary contains no entries.
	 */
	boolean isEmpty();

	/**
	 * Returns the number of entries in the dictionary.
	 * 
	 * @return the number of entries in the dictionary.
	 */
	int size();

	/**
	 * If there is an entry in the dictionary whose key is the specified key,
	 * returns its value; otherwise, returns null.
	 * 
	 * @param key
	 *            The key of the entry to find.
	 * @return Value of the corresponding key if the entry exists. otherwise,
	 *         returns <code>null</code>.
	 */
	V find(K key);

	/**
	 * If there is an entry in the dictionary whose key is the specified key,
	 * replaces its value by the specified value and returns the old value;
	 * otherwise, inserts the entry (key, value) and returns null.
	 * 
	 * @param key
	 *            The key of the entry to insert.
	 * @param value
	 *            Value of the old entry.
	 * @return Value of the corresponding key if the entry exists. otherwise,
	 *         returns <code>null</code>.
	 */
	V insert(K key, V value);

	/**
	 * If there is an entry in the dictionary whose key is the specified key,
	 * removes it from the dictionary and returns its value; otherwise, returns
	 * null.
	 * 
	 * @param key
	 *            The key of the entry to remove.
	 * @return Value of the corresponding key if the entry exists. otherwise,
	 *         returns <code>null</code>.
	 */
	V remove(K key);

	/**
	 * Returns an iterator of the entries in the dictionary.
	 * 
	 * @return Iterator of the entries in the dictionary.
	 */
	Iterator<Entry<K, V>> iterator();

}
