/**
 * 
 */
package dataStructures;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 */
public class EntryClass<K, V> implements Entry<K, V> {

	private static final long serialVersionUID = 1L;

	private K key;

	private V value;

	public EntryClass(K key, V value) {

		this.key = key;
		this.value = value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dataStructures.Entry#getKey()
	 */
	@Override
	public K getKey() {

		return key;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dataStructures.Entry#getValue()
	 */
	@Override
	public V getValue() {

		return value;
	}

	/**
	 * Actualiza a chave existente com a nova chave indicada.
	 * 
	 * @param key
	 *            Nova chave.
	 */
	public void setKey(K key) {
		this.key = key;
	}

	/**
	 * Actualiza o valor existente com o valor indicada.
	 * 
	 * @param value
	 *            Novo valor.
	 */
	public void setValue(V value) {
		this.value = value;
	}

}
