/**
 * 
 */
package dataStructures;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 */
public class SepChainHashTableIterator<K, V> implements Iterator<Entry<K, V>> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Tabela de dicionrios (entries) a iterar.
	 */
	private Dictionary<K, V>[] table;

	/**
	 * Apontador para posio actual na tabela de dicionrios.
	 */
	private int current;

	/**
	 * Iterador actual.
	 */
	private Iterator<Entry<K, V>> it;

	/**
	 * Construtor da SepChainHashTableIterator. Cria e inicializa um iterador
	 * para uma dada tabela.
	 * 
	 * @param table
	 *            Tabela de dispero para a qual ser criado o iterador.
	 */
	public SepChainHashTableIterator(Dictionary<K, V>[] table) {
		
		this.table = table;
		this.rewind();

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dataStructures.Iterator#hasNext()
	 */
	@Override
	public boolean hasNext() {
		if (it == null)
			return false;
		return it.hasNext();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dataStructures.Iterator#next()
	 */
	@Override
	public Entry<K, V> next() throws NoSuchElementException {

		if (!hasNext())
			throw new NoSuchElementException();

		Entry<K, V> entry = it.next();
		if (!hasNext())
			//  necessrio avanar o current, pois esta posio na tabela j
			// foi iterada
			nextIterator(++current);

		return entry;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dataStructures.Iterator#rewind()
	 */
	@Override
	public void rewind() {
		current = 0;
		//Inicializa o it com o prximo iterador de uma lista no vazia.
		nextIterator(current);

	}

	/**
	 * Avana para o prximo iterador cuja lista  no vazia.  necessrio
	 * indicar a posio de partida.
	 * 
	 * @param startPosition
	 *            Posio de partida.
	 */
	private void nextIterator(int startPosition) {
		// Se a table for vazia ou se no houver prximo.
		it = null;
		for (int i = startPosition; i < table.length; i++) {
			if (!table[i].isEmpty()) {
				it = table[i].iterator();
				current = i;
				break;
			}
		}
	}

}
