package schoolSystem;

import dataStructures.*;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 * 
 *         Interface que representa um carto no sistema SchoolSystem. Os
 *         mtodos aqui existentes so apenas de consulta.
 */
/**
 * @author hugoantonio
 * 
 */
public interface Card {

	/**
	 * Devolve o cdigo do carto.
	 * 
	 * @return Cdigo do carto.
	 */
	int getCode();

	/**
	 * Devolve o nome do aluno.
	 * 
	 * @return Nome do aluno.
	 */
	String getName();

	/**
	 * Devolve o saldo do carto.
	 * 
	 * @return Saldo do carto.
	 */
	int getBalance();

	/**
	 * Devolve a turma  qual o aluno pertence.
	 * 
	 * @return Turma do aluno.
	 */
	String getStudentClass();

	/**
	 * Devolve a morada do aluno.
	 * 
	 * @return Morada do aluno.
	 */
	String getAddress();

	/**
	 * Devolve o contacto do aluno.
	 * 
	 * @return Contacto do aluno.
	 */
	String getContact();

	/**
	 * Devolve um produto favorito existente indicando o seu nome.
	 * 
	 * @param productName
	 *            Nome do produto a devolver.
	 * @return Produto favorito com o nome indicado.
	 * @throws CardWithoutFavouritesException
	 *             Caso o carto no tenha produtos favoritos associados.
	 * @throws FavouriteProductInexistenceException 
	 * 				Caso o carto no tenha o produto favorito com o nome indicado.
	 */
	Product getFavouriteProduct(String productName)
			throws CardWithoutFavouritesException, FavouriteProductInexistenceException;

	/**
	 * Devolve os movimentos realizados com o carto.
	 * 
	 * @return Iterador de movimentos realizados com o carto.
	 * @throws CardWithoutTransactionsException
	 *             Caso no existam movimentos realizados pelo carto.
	 */
	Iterator<Transaction> getTransactions()
			throws CardWithoutTransactionsException;

	/**
	 * Devolve iterador para todos os produtos favoritos associados ao carto.
	 * 
	 * @return Iterador de entries de produtos favoritos existentes no carto.
	 * @throws CardWithoutFavouritesException
	 *             Caso o carto no tenha produtos favoritos associados.
	 */
	Iterator<Entry<String, Product>> getFavourites() throws CardWithoutFavouritesException;
}
