package schoolSystem;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 * 
 *         Interface que representa um carto no sistema SchoolSystem. Os
 *         mtodos aqui existentes so todos modificadores.
 */
public interface CardWritable extends Card {

	/**
	 * Recarrega o carto.
	 * 
	 * @param amount
	 *            Valor a adicionar ao saldo.
	 */
	void increaseBalance(int amount);

	
	/**
	 * Adiciona um movimento ao carto.
	 * 
	 * @param product
	 *            Produto.
	 * @param totalItems
	 *            Nmero de itens.
	 */
	void addTransaction(Product product, int totalItems);

	/**
	 * Adiciona um produto aos favoritos do carto.
	 * 
	 * @param p
	 *            Produto a adicionar.
	 * @throws FavouriteProductAlreadyExistsException
	 *             Caso o produto indicado j exista nos favoritos do carto.
	 */
	void addFavourite(Product product) throws FavouriteProductAlreadyExistsException;

	/**
	 * Remove um produto dos favoritos do carto.
	 * 
	 * @param productName
	 *            Nome do produto.
	 * @throws FavouriteProductInexistenceException
	 *             Caso o produto indicado no exista nos favoritos do carto.
	 */
	void removeFavourite(String productName)
			throws FavouriteProductInexistenceException;

	/**
	 * Remove todos os movimentos do carto.
	 */
	void clearTransactions();

}
