package schoolSystem;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 * 
 *         Interface que representa um produto no sistema SchoolSystem. Os
 *         mtodos aqui existentes so apenas de consulta.
 */
public interface Product {

	/**
	 * Devolve o cdigo do produto.
	 * 
	 * @return Cdigo do produto.
	 */
	int getCode();

	/**
	 * Devolve o nome do produto.
	 * 
	 * @return Nome do produto.
	 */
	String getName();

	/**
	 * Devolve o preo do produto.
	 * 
	 * @return Preo do produto.
	 */
	int getPrice();

	/**
	 * Devolve o total monetrio de vendas.
	 * 
	 * @return Valor total monetrio de vendas.
	 */
	int getTotalSales();
	
}
