/**
 * 
 */
package schoolSystem;

import java.io.Serializable;

/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 * 
 *         Classe que implementa a interface Product.
 */
public class ProductClass implements ProductWritable, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Cdigo identificador do produto.
	 */
	private int productCode;

	/**
	 * Nome do produto.
	 */
	private String productName;

	/**
	 * Preo do produto.
	 */
	private int productPrice;

	/**
	 * Valor total monetrio de vendas do produto.
	 */
	private int totalSales;

	/**
	 * Construtor da classe ProductClass.
	 * 
	 * @param productCode
	 *            Cdigo do produto.
	 * @param productName
	 *            Nome do produto.
	 * @param productPrice
	 *            Preo do produto.
	 */
	public ProductClass(int productCode, String productName, int productPrice) {
		this.productCode = productCode;
		this.productName = productName;
		this.productPrice = productPrice;
		this.totalSales = 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Product#getCode()
	 */
	@Override
	public int getCode() {
		return productCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Product#getName()
	 */
	@Override
	public String getName() {
		return productName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Product#getPrice()
	 */
	@Override
	public int getPrice() {
		return productPrice;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Product#getTotalSales()
	 */
	@Override
	public int getTotalSales() {
		return totalSales;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.ProductWritable#increaseTotalSales(int)
	 */
	@Override
	public void increaseTotalSales(int totalItems) {
		assert totalItems >= 0;
		totalSales += (totalItems*productPrice);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.ProductWritable#clearTotalSales()
	 */
	@Override
	public void clearTotalSales() {
		totalSales = 0;
	}

	/**
	 * Devolve a descrio de um produto. Utilizado para a consulta de um produto.
	 * 
	 * @return Uma <code>String</code> com:
	 *         <code>CdidoProduto nomeProduto preoProduto totalVendas</code>.
	 */
	@Override
	public String toString() {
		return productCode + " " + productName + " " + productPrice + " "
				+ totalSales + "\n";
	}
	
	
}
