/**
 * 
 */
package schoolSystem;

import java.io.Serializable;
/**
 * @author Ricardo Gaspar Nr. 35277
 * @author Hugo Antnio Nr. 34334 Turno P2 Docente Vasco Amaral
 * 
 *         Classe que implementa a interface Transaction.
 */
public class TransactionClass implements Transaction, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Cdigo do produto.
	 */
	private int productCode;

	/**
	 * Nmero total de itens.
	 */
	private int totalItems;

	/**
	 * Custo total do movimento.
	 */
	private int totalCost;

	/**
	 * Construtor da classe TransactionClass.
	 * 
	 * @param productCode
	 *            Cdigo do produto.
	 * @param totalItems
	 *            Nmero total de itens.
	 */
	public TransactionClass(int productCode, int totalItems, int productPrice) {
		this.productCode = productCode;
		this.totalItems = totalItems;
		this.totalCost = totalItems * productPrice;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Transaction#getProductCode()
	 */
	@Override
	public int getProductCode() {
		return productCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Transaction#getTotalItems()
	 */
	@Override
	public int getTotalItems() {
		return totalItems;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see schoolSystem.Transaction#getTotalCost()
	 */
	@Override
	public int getTotalCost() {
		return totalCost;
	}

	/**
	 * Devolve a descrio de um movimento. Utilizado para as listagens.
	 * 
	 * @return Uma <code>String</code> com:
	 *         <code>cdigoProduto nmeroItens custoTotal</code>.
	 */
	@Override
	public String toString() {
		return productCode + " " + totalItems + " " + totalCost + ".";
	}

}
