import java.lang.Exception;
import java.io.*;

public class Main {

	@SuppressWarnings("serial")
	public class SyntaxErrorException extends Exception {
	}

	BufferedReader r;
	Stack stack;

	Main() {
		stack = new Stack();
		r = new BufferedReader(new InputStreamReader(System.in));
	}

	public Symbol nextSymbol() throws SyntaxErrorException, IOException {
		String image;
		char c;
		{
			image = "";
			while (Character.isSpaceChar((c = (char) r.read()))) {
			}
			;
			image = image + c;
			if (c < ' ')
				return new Symbol(SymbolTag.ENDINPUT, true);
			else if (c == '(')
				return new Symbol(SymbolTag.LPAR, true);
			else if (c == ')')
				return new Symbol(SymbolTag.RPAR, true);
			else if (c == ',')
				return new Symbol(SymbolTag.COMMA, true);
			else if (c == '_')
				return new Symbol(SymbolTag.UNDERSCORE, true);
			else if (Character.isDigit(c))
				return new Symbol(SymbolTag.DIGIT, true);
			else if (c >= 'a' && c <= 'z')
				return new Symbol(SymbolTag.LETTER, true);
			else
				throw new SyntaxErrorException();
		}
	}

	public void parseInput() throws SyntaxErrorException, IOException {
		Symbol currentSymbol;
		Symbol stackSymbol;

		currentSymbol = nextSymbol();
		stack.push(new Symbol(SymbolTag.I, false));

		while (!(stack.isEmpty())) {
			
			stackSymbol = stack.top();
			if (stackSymbol.isTerminal()) {
				if (stackSymbol.matches(currentSymbol)) {
					stack.pop();
					currentSymbol = nextSymbol();
				} else
					throw new SyntaxErrorException();
			} else {


				switch (stackSymbol.getTag()) {

				case I: {
					switch (currentSymbol.getTag()) {
					case LPAR: /* I -> LExp $ */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					case UNDERSCORE: /* I -> LExp $ */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					case DIGIT: /* I -> LExp $ */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					case LETTER: /* I -> LExp $ */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case LEXP: {
					switch (currentSymbol.getTag()) {
					case LPAR: /* LExp -> List */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LIST, false));
						break;
					}
					case UNDERSCORE: /* LExp -> Atom */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.ATOM, false));
						break;
					}
					case DIGIT: /* LExp -> Atom */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.ATOM, false));
						break;
					}
					case LETTER: /* LExp -> Atom */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.ATOM, false));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case ATOM: {
					switch (currentSymbol.getTag()) {
					case UNDERSCORE: /* Atom -> ID */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.ID, false));
						break;
					}
					case DIGIT: /* Atom -> NUM */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.NUM, false));
						break;
					}
					case LETTER: /* Atom -> ID */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.ID, false));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case LIST: {
					switch (currentSymbol.getTag()) {
					case LPAR: { /* List -> <lpar> LSeq <rpar> */
						stack.pop();
						stack.push(new Symbol(SymbolTag.RPAR, true));
						stack.push(new Symbol(SymbolTag.LSEQ, false));
						stack.push(new Symbol(SymbolTag.LPAR, true));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case LSEQ: {
					switch (currentSymbol.getTag()) {
					case LPAR: /* LSeq -> LExp LC */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LC, false));
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					case UNDERSCORE: /* LSeq -> LExp LC */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LC, false));
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					case DIGIT: /* LSeq -> LExp LC */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LC, false));
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					case LETTER: /* LSeq -> LExp LC */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LC, false));
						stack.push(new Symbol(SymbolTag.LEXP, false));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case LC: {
					switch (currentSymbol.getTag()) {
					case COMMA: /* LC -> <comma> List */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.LIST, false));
						stack.push(new Symbol(SymbolTag.COMMA, true));
						break;
					}
					case RPAR: /* LC -> empty */{
						stack.pop();
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case NUM: {
					switch (currentSymbol.getTag()) {
					case DIGIT: /* NUM -> <digit> NC */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.NC, false));
						stack.push(new Symbol(SymbolTag.DIGIT, true));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case NC: {
					switch (currentSymbol.getTag()) {
					case RPAR: /* NC -> empty */{
						stack.pop();
						break;
					}
					case COMMA: /* NC -> empty */{
						stack.pop();
						break;
					}
					case ENDINPUT: /* NC -> empty */{
						stack.pop();
						break;
					}
					case DIGIT: /* NC -> <digit> NC */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.NC, false));
						stack.push(new Symbol(SymbolTag.DIGIT, true));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case ID: {
					switch (currentSymbol.getTag()) {
					case UNDERSCORE: /* ID -> F <letter> IDc */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.IDC, false));
						stack.push(new Symbol(SymbolTag.LETTER, true));
						stack.push(new Symbol(SymbolTag.F, false));
						break;
					}
					case LETTER: /* ID -> F <letter> IDc */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.IDC, false));
						stack.push(new Symbol(SymbolTag.LETTER, true));
						stack.push(new Symbol(SymbolTag.F, false));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case F: {
					switch (currentSymbol.getTag()) {
					case UNDERSCORE: /* F -> <underscore> */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.UNDERSCORE, true));
						break;
					}
					case LETTER: /* F -> empty */{
						stack.pop();
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				case IDC: {
					switch (currentSymbol.getTag()) {
					case RPAR: /* IDc -> empty */{
						stack.pop();
						break;
					}
					case COMMA: /* IDc -> empty */{
						stack.pop();
						break;
					}

					case ENDINPUT: /* IDc -> empty */{
						stack.pop();
						break;
					}

					case DIGIT: /* IDc -> <digit> IDc */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.IDC, false));
						stack.push(new Symbol(SymbolTag.DIGIT, true));
						break;
					}
					case LETTER: /* IDc -> <letter> IDc */{
						stack.pop();
						stack.push(new Symbol(SymbolTag.IDC, false));
						stack.push(new Symbol(SymbolTag.LETTER, true));
						break;
					}
					default:
						throw new SyntaxErrorException();
					}
					;
					break;
				}

				// default:
				// throw new SyntaxErrorException();
				}
			}
		}
		if (currentSymbol.getTag() != SymbolTag.ENDINPUT)
			throw new SyntaxErrorException();
	}

	static public void main(String[] args) throws Exception {

		Main parser = new Main();
		try {
			parser.parseInput();
			System.out.println("Accepted");
		} catch (SyntaxErrorException e) {
			System.out.println("Syntax Error");
		}
	}

}
