(* Trabalho realizado por Ricardo Gaspar n35277 e Ricardo Cruz n34951*)
(*Neste trabalho apenas no foi realizada a funo FIND, pois apesar do*)
(*empenho de ambos, a dificuldade na concretizao desta funo revelou*)
(*o pouco -vontade dos alunos no paradigma funcional e na sintaxe do Ocaml.*)
(*De salientar e agradecer a ajuda e disponibilidade do Professor Artur *)
(*Miguel Dias no esclarecimento de todas as dvidas e resoluo de alguns*)
(*problemas que surgiram na elaborao do mesmo. O balano  positivo pois*)
(*houve progressos no conhecimento da linguagem.*) 


(* Definio do tipo de dados *)
type fileSys = File of string * string list | Dir of string * fileSys list
;;


(* Definio da estrutura dos ficheiros *)
type path = string list ;; 


(*exemplo*)
let example =
    Dir("root",
           [File("fich",["primeira linha.";"segunda linha."]);
            Dir("tmp",[File("z",["zzzzzz"; ""; "wwwww"])]);
            Dir("tmp2",[]);
            File("fich2",["Era uma vez"]);
            File("fich3",[]);
           ]
    )
;;


(* Auxiliary definitions *)

let getName z =
    match z with
          File(name, _) -> name
        | Dir(name, _) -> name
;;


let getSub z =
    match z with
          File(_, _) -> []
        | Dir(_, zs) -> zs
;;


let rec addFirst e z =
    match z with
          File(_, _) -> raise (Arg.Bad "addFirst: File not expected")
        | Dir(name, zs) -> Dir(name, e::zs)
;;


(* Funo que conta o nmero de ficheiros *)	
let rec countFiles z =
	match z with
		  File(name, ls) -> 1
		| Dir(name, []) -> 0
		| Dir(name, z::zs) -> countFiles z + countFiles (Dir(name, zs))
;;


(* Funo que conta o nmero de directorias *)
let rec countDirs z =
	match z with
		  Dir(name, []) -> 1
		| File(name, ls) -> 0
		| Dir(name, z::zs) -> countDirs z + countDirs (Dir(name, zs))
;;


(* Funo que conta o nmero de carateres contidos em todas as linhas do *)
(* sistema de ficheiros *)
let rec size z = 
	match z with
			Dir(name, []) -> 0
		| File(name,[]) -> 0	
		| File(name, l::ls) -> String.length (l) + size (File(name,ls))
		| Dir(name, x::xs) -> size (x) + size (Dir(name,xs))
;;


(* Funo auxiliar que mede a altura do sistema de ficheiros *)
let rec lheight z =
    match z with
      [] -> 0
			| Dir(name, []) ::xs -> Pervasives.max (1) (lheight xs)
      | File(name, ls)::xs -> Pervasives.max (1) (lheight xs)
      | Dir(name, zs) ::xs -> Pervasives.max (1+ (lheight zs )) (lheight xs) 
;;

(* Funo que mede a altura do sistema de ficheiros *)
let height z = lheight[z]
;;


(* Funo auxiliar que devolve o valor mximo de uma lista *)
let rec maxList l =
        match l with
          [] -> raise (Arg.Bad "A Lista vazia no tem tamanho maximo")
					|[x] -> x
          | x::xs -> Pervasives.max x (maxList xs)
;;


(* Funo auxiliar que soma os elementos de 2 listas *)
let rec sumLists l1 l2 =
        match l1,l2 with
            [],l -> l
          | l,[] -> l
          | x::xs, y::ys -> (x+y)::sumLists xs ys
;;


(*funo auxiliar que divide uma arvore e-naria em niveis*)
let rec levels t =
    match t with		
						Dir(name, []) -> [1]
					| File(name, _)-> [1]
          | Dir(name, y::ys) -> sumLists (0::levels y) (levels(Dir(name, ys)))
;;


(* Funo que mede a largura do sistema de ficheiros *)
let width t =
       match t with 
					Dir(name, []) -> 1
				 |File(name, ls)-> 1
         |Dir(name, y::ys) -> maxList (levels t) 
;;


(* Funo que verifica a validade de um dado caminho, verifica se o ficheiro*)
(*  existe*)
let rec check p z =  
    match p, z with
          [], _ -> true
        | x::xs, Dir(name, z::zs) ->
                if x = getName z then check xs z
                else check p (Dir(name, zs))
        | _, _ -> false
;;


(*funo auxiliar que coloca o ltimo elemento de uma lista  cabea*)
let rotate l =
    let len = List.length l in
		let n = len-1 in
			let rec rotate l n =
        if (n=0) then l
        else match l with
            [] -> []
            | x::xs -> rotate (xs@[x]) (n-1)
    in
    rotate l n
;;


(* Funo que sobe um nvel na hierarquia do sistema de ficheiros*)
(*  devolvendo o caminho absoluto*)
let up p =
	if List.length p>1 then
		let q = rotate p in
			match q with
			[]->[]
			|x::xs -> xs
  else p
;;


(* Funo que coloca um valor no final de uma lista*)
let rec putAtEnd v l =
    match l with
			[] -> [v]
      | x::xs -> x::putAtEnd v xs
;;


(* Funo auxiliar que devolve um elemento do tipo filesys*)
let rec give p z =
				match p , z with
					[], _ -> z
        | x::xs, Dir(name, y::ys) ->
                if x = getName y then give xs y
                else give p (Dir(name, ys))
        | _, _ -> raise (Arg.Bad "elemento invalido1")
;;


(* Funo que chama a funo auxiliar give que por sua vez devolve um *)
(* elemento*)
(*  do tipo filesys *)
let get p z = 
	if check p z = true then give p z 
		else raise (Arg.Bad "elemento invalido2")
;;


(* Funo que desce um nvel na hierarquia de ficheiros devolvendo o seu *)
(* caminho absoluto *)
let down name z p = 
		let q = putAtEnd name p in
			if check q z = true then 
			let s= get q z in
			 match s with
					Dir(name, []) -> q
				 |File(name, ls)-> q
         |Dir(name, y::ys) -> q
			else raise (Arg.Bad "caminho invlido")				
;;


(* Funo auxiliar que adiciona um filesys a um filesys *)
let rec ad z1 p z2 = 
	match p , z2 with
				[], _ -> addFirst z1 z2
        |[x],Dir(name, y::ys)-> 
		if x = getName y then Dir(name, addFirst (z1) (y) ::ys)
		else addFirst y (ad z1 p (Dir(name, ys)))
	|x::xs, Dir(name, y::ys) ->
                if x = getName y then Dir(name, (ad z1 xs y)::ys)
                else addFirst y (ad z1 p (Dir(name, ys)))
        | _, _ -> raise (Arg.Bad "nao e possivel adicionar")
;;


(* Funo que adiciona um FileSys a outro FileSys num dado path*)
let add z1 p z2 = if check p z2 = true 
	&& check (putAtEnd (getName z1) p) z2 = false 
	then ad z1 p z2
	else raise (Arg.Bad "nao e possivel remover")
;;


(* Funo que remove um filesys a um filesys *)
let rec rm p z = 
	match p , z with
	[], _ -> raise (Arg.Bad "nao e possivel remover a raiz")
        |[x],Dir(name, y::ys)-> 
		if x = getName y then Dir(name, ys)
		else addFirst y (rm p (Dir(name, ys)))	
	|x::xs, Dir(name, y::ys) ->
                if x = getName y then Dir(name, (rm xs y)::ys)
                else addFirst y (rm p (Dir(name, ys)))
        | _, _ -> raise (Arg.Bad "nao e possivel remover")
;;


(* Funo que procura uma substring em todos os ficheiros de um dado FileSys*)
let find str z = [] ;;


(*Funo que l e anexa todas as linhas de um ficheiro*)
let rec composeNString n cin = 
			if n = 0 then []
			else let str = input_line cin in 
				[str]@(composeNString (n-1) cin)

;;
	  
		 
(*Funo auxiliar do load que permite a criao do FileSys a partir do canal de*)
(*  leitura do ficheiro*)
let rec  constructSingleFileSys cin =
    try
      let s = input_line cin in
	let name = input_line cin in
	  let n = int_of_string (input_line cin) in
	   match s with
	    "d" -> Dir(name, constructNFileSys n  cin)
	   |"f" -> File(name, (composeNString n cin))
	   | _ -> raise (Arg.Bad "Linha vazia")
           with End_of_file -> 
           raise (Arg.Bad "constructSingleFileSys: invalid file") 
           and constructNFileSys nfiles cin =		
	   try 
           if nfiles = 0 then []
	   else constructSingleFileSys cin::constructNFileSys (nfiles-1) cin
	   with End_of_file -> 
           raise (Arg.Bad "constructNFileSys: invalid file") 
;;	


(* Funo que cria um FileSys a partir de um ficheiro*)
let load filename = 
		let cin = open_in filename in
			 let res = constructSingleFileSys cin in
					close_in cin ; res
;;


(*Funo auxiliar que coloca uma lista de FileSys numa String*)
let rec toString z = 
	match z with
	[] -> ""
	|Dir(dirname,[])::xs -> "d\n"^dirname^"\n"^"0\n"^toString(xs)	
	|Dir(dirname,list)::xs ->"d\n"^dirname^"\n"
		^string_of_int (List.length list)^"\n"^toString(list)^toString(xs)
	|File(filename,slist)::xs -> "f\n"^filename^"\n"
		^(string_of_int (List.length slist))^(String.concat "\n" slist)^"\n"
		^toString(xs)

;;


(* Funo que guarda um FileSys num ficheiro*)
let store name z = 
   let cout = open_out name in
			output_string cout (toString([z]));
      close_out cout
;;


(* Funo que coloca identacao nas linhas *)
let rec tab n = 
    if n = 0 then ()
    else (print_string "    " ; tab (n-1)) 
;;


(* Funo auxiliar que imprime um filesys*)
let rec showi z n=
	tab n;
    match z with
    File(name, ls) -> print_string ("+"^name^"\n"); 
    List.iter (fun l  -> tab (n+1); print_string (l^"\n")) ls    
    | Dir(name, zs) -> print_string ("*"^name^"\n") ; 
    List.iter (fun z  -> showi z (n+1)) zs 
;;


(* Funo que imprime um filesys *)
let show z = showi z 0 ;;


(* Mtodo indutivo aplicado a strings. A funo cut "separa a cabea da cauda",*)
(*  numa string. *) 
let cut s =  (* pre: s <> "" *) 
    (String.get s 0, String.sub s 1 ((String.length s)-1)) 
;;


let rec split s =                      (* parte a string s no primeiro ' ' *) 
    if s = "" then ("", "")            (* caso base *) 
    else 
      let (x,xs) = cut s in            (* separa cabea da cauda *) 
         if x = ' ' then ("", xs)      (* outro caso base *) 
         else let (a,b) = split xs in  (* chamada recursiva para a cauda *) 
             ((Char.escaped x)^a,b) 
;;


(* Funo que imprime ajuda *)
let help () = 
    print_string "Comandos vlidos:\n" ; 
    print_string "    mostra fich\n" ; 
    print_string "    maximo fich\n" ; 
    print_string "    ajuda\n" ; 
    print_string "    sair\n" 
;; 


(* Funo que imprime erros *)
let error mesg = 
    output_string stderr mesg ; 
    output_string stderr "!\n" ; 
    flush stderr 
;;


(* Funo que termina o programa *)
let byeBye () = 
    exit 0 
;;


(* Funo auxiliar que imprime uma string no formato unix *)
let pw p = "/"^String.concat "/" p^"\n"
;;


(* Funo que executa os comandos*)
let exec p z comm filename = 
    match comm with 
        "count" ->print_int(countFiles z);print_string"\n";(p , z) 
      | "load name" -> ([], load filename)
      | "show" -> show z;(p,z) 
      | "pwd" -> print_string (pw p); (p,z)
      | "up" -> ((up p),z)
      | "down name" -> ((down filename z p),z)
      | "quit" -> (ignore (exit 0)); (p,z)
      | _ -> help ();( p,z) 
;;


(* Funo que inicia o interpretador *)
let rec runInterpreter p z = 
    (try 
        print_string "> " ; 
        let line = read_line () in 
            let (comm, arg) = split line in 
                let (newp, newz) = exec p z comm arg in 
                    runInterpreter newp newz 
    with 
       End_of_file -> byeBye () 
     | Sys_error str -> error str 
     | _ -> error "Erro") ; 
    runInterpreter p z 
;; 


(* Funo que instacia o interpretador *)
let interpreter () = 
runInterpreter [] (Dir("root", [])) 
;;
