/**
 * @author Eduardo Lopes Nr 35469
 * @author Ricardo Gaspar Nr 42038
 * Docente: Fernando Birra Turno: P6
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import javax.media.opengl.*;
import javax.swing.text.html.MinimalHTMLWriter;

public class ObjectLoader {

	private final static String OBJ_VERTEX = "v";
	private final static String OBJ_VERTEX_TEXTURE = "vt";
	private final static String OBJ_FACE = "f";

	ArrayList<Vertex> vertices;
	ArrayList<Vertex> verticesTextura;
	ArrayList<Face> faces;
	double maxVerticeX = Double.MIN_VALUE;
	double minVerticeX = Double.MAX_VALUE;
	double centroX = 0;
	double distanciaX = 0;

	double maxVerticeY = Double.MIN_VALUE;
	double minVerticeY = Double.MAX_VALUE;
	double centroY = 0;
	double distanciaY = 0;

	double maxVerticeZ = Double.MIN_VALUE;
	double minVerticeZ = Double.MAX_VALUE;
	double centroZ = 0;
	double distanciaZ = 0;

	ObjectLoader() {

		// verticesLidos = new ArrayList<Vertex>();
		// verticesTexturaLidos = new ArrayList<Vertex>();

		// indicesVertices = new ArrayList<Integer>();
		// indicesVerticesTextura = new ArrayList<Integer>();
		// vertices de saida - apos ler faces
		vertices = new ArrayList<Vertex>();
		verticesTextura = new ArrayList<Vertex>();
		faces = new ArrayList<Face>();

	}

	public void load(File objFile) throws IOException 
	{

		FileReader fileReader = new FileReader(objFile);
		BufferedReader bufferedReader = new BufferedReader(fileReader);


		String line = null;
		while (true) {
			line = bufferedReader.readLine();
			if (null == line) {
				break;
			}

			line = line.trim();

			if (line.length() == 0)
				continue;

			String tokens[] = line.split("[\t ]+");


			if (line.startsWith("#")) {
				continue;
			} else if (tokens[0].equals(OBJ_VERTEX)) {
				// parse vertex line
				vertices.add(new Vertex(Float.parseFloat(tokens[1]), Float
						.parseFloat(tokens[2]), Float.parseFloat(tokens[3])));

			} else if (tokens[0].equals(OBJ_VERTEX_TEXTURE)) {
				// parse texture coordinates
				verticesTextura.add(new Vertex(Float.parseFloat(tokens[1]),
						Float.parseFloat(tokens[2]), 1));

			} else if (tokens[0].equals(OBJ_FACE)) {
				// parse face information
				String[] ponto = null;
				Vertex[] verticesLidos = new Vertex[tokens.length - 1];
				Vertex[] verticesTexturaLidos = new Vertex[tokens.length - 1];

				// Leitura dos vertices dos pontos para arrays
				for (int i = 1; i < tokens.length; i++) {
					ponto = tokens[i].trim().split("/");

					// subtrair 1 pois os indices comecam em 1 e nos arrays
					// comecam em 0
					if(vertices.size() != 0)
						verticesLidos[i - 1] = vertices.get(Integer
							.parseInt(ponto[0]) - 1);
					try {

							verticesTexturaLidos[i - 1] = verticesTextura.get(Integer
								.parseInt(ponto[1]) - 1);
						
					} catch (Exception e) {
						//ignora no caso de não haver texturas
						
					}
					

					// Calculo dos minimos e maximos
					if (verticesLidos[i - 1].x > maxVerticeX)
						maxVerticeX = verticesLidos[i - 1].x;
					if (verticesLidos[i - 1].x < minVerticeX)
						minVerticeX = verticesLidos[i - 1].x;

					if (verticesLidos[i - 1].y > maxVerticeY)
						maxVerticeY = verticesLidos[i - 1].y;
					if (verticesLidos[i - 1].y < minVerticeY)
						minVerticeY = verticesLidos[i - 1].y;

					if (verticesLidos[i - 1].z > maxVerticeZ)
						maxVerticeZ = verticesLidos[i - 1].z;
					if (verticesLidos[i - 1].z < minVerticeZ)
						minVerticeZ = verticesLidos[i - 1].z;

				}
				// crias as faces com os vertices necessários
				faces.add(new Face(verticesLidos, verticesTexturaLidos));

			}

		}

		centroX = ((maxVerticeX - minVerticeX) / 2) + minVerticeX;
		centroY = ((maxVerticeY - minVerticeY) / 2) + minVerticeY;
		centroZ = ((maxVerticeZ - minVerticeZ) / 2) + minVerticeZ;
		
		distanciaX = maxVerticeX - minVerticeX;
		distanciaY = maxVerticeY - minVerticeY;
		distanciaZ = maxVerticeZ - minVerticeZ;

		bufferedReader.close();


	}



}
