import javax.swing.JPanel;
import javax.swing.JFrame;

import java.awt.BorderLayout;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

import javax.swing.AbstractButton;

import javax.swing.JCheckBoxMenuItem;

import javax.swing.JFileChooser;

import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.event.WindowAdapter;
import java.awt.image.*;
import java.io.File;

import java.io.IOException;
import java.nio.ByteBuffer;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.imageio.ImageIO;
import javax.media.opengl.*;

import javax.media.opengl.glu.GLU;
import com.sun.opengl.util.GLUT;

//import javax.media.opengl.GLEventListener;
//import javax.media.opengl.GL;
//import javax.media.opengl.GLAutoDrawable;
//import javax.media.opengl.GLCanvas;

/**
 * @author Eduardo Lopes Nr 35469
 * @author Ricardo Gaspar Nr 42038 Docente: Fernando Birra Turno: P6
 */
public class VisualizadorObj3D implements GLEventListener, KeyListener {

	public void init(GLAutoDrawable gLDrawable) {
		glDraw = gLDrawable;
		GL gl = gLDrawable.getGL();
		gl.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
		// Z-BUFFER activo
		gl.glEnable(GL.GL_DEPTH_TEST);
		glDraw.addKeyListener(this);
		// Podem adicionar-se outros listeners aqui (e.g. os do rato)

	}

	public void display(GLAutoDrawable gLDrawable) {
		GL gl = gLDrawable.getGL();

		// Limpa o ecran e o Z-buffer
		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
		gl.glMatrixMode(GL.GL_PROJECTION);
		gl.glLoadIdentity();

		if (width > height)
			gl.glOrtho(-1 * (width / height) * (1 / zoomFactor), 1
					* (width / height) * (1 / zoomFactor), -1
					* (1 / zoomFactor), 1 * (1 / zoomFactor), 1, -1);
		else
			gl.glOrtho(-1 * (1 / zoomFactor), 1 * (width / height)
					* (1 / zoomFactor), -1 * (width / height)
					* (1 / zoomFactor),
					1 * (width / height) * (1 / zoomFactor), 1, -1);

		realizaProjeccao(gl);
		gl.glMatrixMode(GL.GL_MODELVIEW);
		gl.glLoadIdentity();
		// Activar a opção de textura apenas quando existe uma carregada
		if (ficheiroTextura == null)
			texturaCheckBox.setEnabled(false);
		else
			texturaCheckBox.setEnabled(true);
		
		if (objecto != null) {
			desenhaObjecto(gl);

		}

	}

	public void reshape(GLAutoDrawable gLDrawable, int x, int y, int width,
			int height) {
		GL gl = gLDrawable.getGL();

		this.width = width;
		this.height = height;

		gl.glViewport(0, 0, width, height);

	}

	public void displayChanged(GLAutoDrawable gLDrawable, boolean modeChanged,
			boolean deviceChanged) {
	}

	public static void reDesenhar() {
		glDraw.display();
	}

	public static JPanel criarPainel() {
		JPanel painelControlo = criarPainelControlo();

		JPanel painel = new JPanel();

		painel.add(painelControlo);
		return painel;
	}

	public static JPanel criarPainelControlo() {

		painelAbas = new JTabbedPane();

		JPanel painelProjeccaoOrtogonal = criarPainelPOrtogonal();
		JPanel painelProjeccaoObliqua = criarPainelPObliqua();
		JPanel painelProjeccaoAxonometrica = criarPainelPAxonometrica();
		JPanel painelProjeccaoPerspectiva = criarPainelPPerspectiva();

		JPanel painelControlo = new JPanel();
		painelAbas.addTab("Projecção Ortogonal", painelProjeccaoOrtogonal);

		painelAbas.addTab("Projecção Oblíqua", painelProjeccaoObliqua);

		painelAbas
				.addTab("Projecção Axonométrica", painelProjeccaoAxonometrica);

		painelAbas.addTab("Projecção Perspectiva", painelProjeccaoPerspectiva);

		painelAbas.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				reDesenhar();
			}
		});
		painelAbas.setSelectedComponent(painelProjeccaoOrtogonal);
		painelControlo.add(painelAbas);
		painelControlo.setLayout(new GridLayout(1, 1));

		return painelControlo;
	}

	public static JPanel criarPainelPOrtogonal() {

		class RBListener implements ActionListener {

			public void actionPerformed(ActionEvent event) {
				reDesenhar();
			}
		}

		RBListener listener = new RBListener();

		alcadoPrincipal = new JRadioButton("Alçado Principal", true);
		alcadoPrincipal.addActionListener(listener);

		alcadoEsquerdo = new JRadioButton("Alçado Lateral Esquerdo");
		alcadoEsquerdo.addActionListener(listener);

		alcadoDireito = new JRadioButton("Alçado Lateral Direito");
		alcadoDireito.addActionListener(listener);

		planta = new JRadioButton("Planta");
		planta.addActionListener(listener);

		ButtonGroup grupo = new ButtonGroup();
		grupo.add(alcadoPrincipal);
		grupo.add(alcadoEsquerdo);
		grupo.add(alcadoDireito);
		grupo.add(planta);

		JPanel painel = new JPanel();
		painel.add(alcadoPrincipal);
		painel.add(alcadoEsquerdo);
		painel.add(alcadoDireito);
		painel.add(planta);
		return painel;
	}

	public static JPanel criarPainelPObliqua() {

		class RBListener implements ActionListener {

			public void actionPerformed(ActionEvent event) {
				reDesenhar();
			}
		}

		RBListener listener = new RBListener();

		gabinete = new JRadioButton("Gabinete", true);
		gabinete.addActionListener(listener);

		cavaleira = new JRadioButton("Cavaleira");
		cavaleira.addActionListener(listener);

		ortogonal = new JRadioButton("Ortogonal");
		ortogonal.addActionListener(listener);

		ButtonGroup grupo = new ButtonGroup();
		grupo.add(gabinete);
		grupo.add(cavaleira);
		grupo.add(ortogonal);

		JPanel painel = new JPanel();
		painel.add(gabinete);
		painel.add(cavaleira);
		painel.add(ortogonal);

		return painel;
	}

	public static JPanel criarPainelPAxonometrica() {
		// Como os sliders são de inteiros tivemos representar cada grau como
		// 1000 para usarmos uma precisão de duas casas decimais.

		class mySlider extends JSlider {

			private static final long serialVersionUID = 1L;

			public mySlider(double minimum, double maximum, double value) {
				super((int) (minimum * 100), (int) (maximum * 100),
						(value < 0) ? (int) ((value + 360) * 100)
								: (int) (value * 100));
			}

			@Override
			public void setMajorTickSpacing(int n) {
				super.setMajorTickSpacing(n * 100);
			}

			@Override
			public void setMinorTickSpacing(int n) {
				super.setMinorTickSpacing(n * 100);
			}

			public double getDoubleValue() {

				return (double) (getValue() / 100.0);
			}

		}

		mySlider tetaSlider = new mySlider(0, 359.9, calculaTetaInicial());
		final JLabel tetaLabel = new JLabel("Ângulo Teta: "
				+ tetaSlider.getDoubleValue() + "º");

		teta = tetaSlider.getDoubleValue();

		tetaSlider.setMajorTickSpacing(90); // Traço grosso a cada 90º
		tetaSlider.setMinorTickSpacing(45); // Traço fino a cada 45º
		tetaSlider.setPaintTicks(true);

		mySlider gamaSlider = new mySlider(0, 359.9, calculaGamaInicial());
		final JLabel gamaLabel = new JLabel("Ângulo Gama: "
				+ gamaSlider.getDoubleValue() + "º");

		gama = gamaSlider.getDoubleValue();

		gamaSlider.setMajorTickSpacing(90); // Traço grosso a cada 90º
		gamaSlider.setMinorTickSpacing(45); // Traço fino a cada 45º
		gamaSlider.setPaintTicks(true);

		// LABELS DOS ÂNGULOS
		Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
		labelTable.put(new Integer(0), new JLabel("0º"));
		labelTable.put(new Integer(9000), new JLabel("90º"));
		labelTable.put(new Integer(18000), new JLabel("180º"));
		labelTable.put(new Integer(27000), new JLabel("270º"));
		labelTable.put(new Integer(35900), new JLabel("359º"));

		tetaSlider.setLabelTable(labelTable);
		tetaSlider.setPaintLabels(true);
		gamaSlider.setLabelTable(labelTable);
		gamaSlider.setPaintLabels(true);

		class tetaSliderListener implements ChangeListener {
			public void stateChanged(ChangeEvent event) {
				// Source with Slider Value
				mySlider source = (mySlider) event.getSource();
				teta = source.getDoubleValue();
				// Update the Label
				tetaLabel.setText("Ângulo Teta: " + teta + "º");
				reDesenhar();
			}

		}
		class gamaSliderListener implements ChangeListener {
			public void stateChanged(ChangeEvent event) {
				// Source with Slider Value
				mySlider source = (mySlider) event.getSource();
				gama = source.getDoubleValue();
				// Update the Label
				gamaLabel.setText("Ângulo Gama: " + gama + "º");
				reDesenhar();
			}
		}

		tetaSlider.addChangeListener(new tetaSliderListener());
		gamaSlider.addChangeListener(new gamaSliderListener());

		JPanel painel = new JPanel();
		painel.setLayout(new GridLayout(1, 2));

		painel.add(tetaSlider);
		painel.add(tetaLabel);
		painel.add(gamaSlider);
		painel.add(gamaLabel);

		return painel;
	}

	public static JPanel criarPainelPPerspectiva() {

		final JTextField centroProj = new JTextField(4);
		centroProj.setEditable(true);
		// Inicializa o campo de texto
		centroProj.setText(centroPrespectivaD + "");
		centroProj.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				try {
					centroPrespectivaD = Double.parseDouble(centroProj
							.getText());
					// Formata o número inserido e actualiza o campode texto
					centroProj.setText(centroPrespectivaD + "");

				} catch (Exception ev) {
					// Coloca o ultimo valor no campo de texto
					centroProj.setText(centroPrespectivaD + "");
				}
				reDesenhar();

			}
		});

		JLabel labelCentroD = new JLabel("Centro de projecção D = ",
				JLabel.LEFT);

		JPanel painel = new JPanel();
		painel.add(labelCentroD);
		painel.add(centroProj);
		return painel;
	}

	public void keyTyped(KeyEvent e) {
		if (e.getKeyChar() == '\u001B' || // escape
				e.getKeyChar() == 'Q' || e.getKeyChar() == 'q') { // quit
			System.exit(0);
		}

		else if (e.getKeyChar() == '+') {
			zoomFactor += zoomFactorStep;
		}

		else if (e.getKeyChar() == '-') {
			// limite para que não inverta o desenho
			if (zoomFactor > zoomFactorStep * 2)
				zoomFactor -= zoomFactorStep;
		}
		reDesenhar();
	}

	public void keyPressed(KeyEvent e) {
	}

	public void keyReleased(KeyEvent e) {
	}

	/**
	 * Menu Ficheiro
	 * 
	 * @return
	 */
	private static JMenu criarMenuFicheiro() {
		JMenu menu = new JMenu("Ficheiro");
		menu.add(criarItemMenuFicheiro("Carregar Objecto"));

		menu.add(criarItemMenuFicheiro("Carregar Textura"));
		menu.add(new JSeparator());
		menu.add(criarItemMenuFicheiro("Sobre"));
		menu.add(criarItemMenuFicheiro("Reiniciar"));

		menu.add(criarItemMenuFicheiro("Sair"));
		return menu;
	}

	/**
	 * Items do Menu Ficheiro
	 * 
	 * @param texto
	 * @return
	 */
	private static JMenuItem criarItemMenuFicheiro(String texto) {
		final JMenuItem item = new JMenuItem(texto);

		class ListenerItemMenu implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				if (e.getActionCommand().equals("Sobre")) {
					JOptionPane
							.showMessageDialog(
									null,
									"Visualizador de Objectos 3D em JOGL\n\nAutores:\nEduardo Lopes Nº 35469\nRicardo Gaspar Nº 42038\nDocente: Fernando Birra Turno: P6\n");
				} else if (e.getActionCommand().equals("Carregar Objecto")) {
					final JFileChooser fileChooser = new JFileChooser();
					fileChooser
							.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
					fileChooser.setCurrentDirectory(new File(System
							.getProperty("user.dir")));
					fileChooser.showOpenDialog(item);
					File file = null;
					try {
						file = fileChooser.getSelectedFile();
						if (!file.getName().endsWith(("obj")))
							throw new Exception();

						objecto = new ObjectLoader();
						objecto.load(file);

					} catch (Exception exception) {
						JOptionPane
								.showMessageDialog(
										null,
										"Não foi possível carregar o objecto pretendido.\nObjecto é inválido. \nVerifique o tipo de ficheiro.");

					}

				} else if (e.getActionCommand().equals("Carregar Textura")) {
					final JFileChooser fileChooser = new JFileChooser();
					fileChooser
							.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
					fileChooser.setCurrentDirectory(new File(System
							.getProperty("user.dir")));
					fileChooser.showOpenDialog(item);

					try {
						ficheiroTextura = fileChooser.getSelectedFile();
					
						if ((!ficheiroTextura.getName().endsWith("png")) && (!ficheiroTextura.getName().endsWith("jpg")))
							throw new Exception();
					} catch (Exception exception) {
						JOptionPane
								.showMessageDialog(
										null,
										"Não foi possível carregar a textura pretendida.\nTextura é inválida. \nVerifique o tipo de ficheiro.");
					}

				} else if (e.getActionCommand().equals("Reiniciar")) {

					frame.remove(barra);
					frame.remove(painel);

					painel = criarPainel();

					barra = new JMenuBar();
					barra.add(criarMenuFicheiro());
					barra.add(criarMenuVer());

					frame.add(barra, BorderLayout.NORTH);
					frame.add(painel, BorderLayout.SOUTH);

					// validar alterações.
					frame.validate();

					zoomFactor = 1;
					objecto = null;
					// textura = null;

				} else if (e.getActionCommand().equals("Sair"))
					System.exit(0);
				reDesenhar();
			}

		}

		item.addActionListener(new ListenerItemMenu());
		return item;
	}

	/**
	 * Menu Ver
	 * 
	 * @return
	 */
	private static JMenu criarMenuVer() {
		JMenu menu = new JMenu("Ver");

		menu.add(criarItemMenuVer("Wireframe"));
		menu.add(criarItemMenuVer("Sólido"));
		menu.add(criarItemMenuVer("Textura"));
		menu.add(criarItemMenuVer("Bounding Box"));
		return menu;
	}

	/**
	 * Items do Menu Ver
	 * 
	 * @param texto
	 * @return
	 */
	private static JMenuItem criarItemMenuVer(String texto) {
		JMenuItem item = new JMenuItem(texto);
		if (texto.equals("Wireframe")) {
			item = new JCheckBoxMenuItem(texto, true);
			wireframeActivo = true;

		} else if (texto.equals("Sólido")) {
			item = new JCheckBoxMenuItem(texto, false);
			solidoActivo = false;
		} else if (texto.equals("Textura")) {
			item = new JCheckBoxMenuItem(texto, false);
			texturaActiva = false;
			item.setEnabled(false); // coloca o menu a cinza e não seleccionável
			texturaCheckBox = item;

		} else if (texto.equals("Bounding Box")) {
			item = new JCheckBoxMenuItem(texto, false);
			boundingBoxActiva = false;

		}

		class ListenerItemMenu implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				if (e.getActionCommand().equals("Wireframe")) {
					AbstractButton checkbox = (AbstractButton) e.getSource();
					if (checkbox.isSelected()) {
						wireframeActivo = true;

					} else {
						wireframeActivo = false;

					}
				} else if (e.getActionCommand().equals("Sólido")) {
					AbstractButton checkbox = (AbstractButton) e.getSource();
					if (checkbox.isSelected())
						solidoActivo = true;
					else
						solidoActivo = false;
				} else if (e.getActionCommand().equals("Textura")) {
					AbstractButton checkbox = (AbstractButton) e.getSource();

					if (checkbox.isSelected())
						texturaActiva = true;
					else
						texturaActiva = false;

				} else if (e.getActionCommand().equals("Bounding Box")) {
					AbstractButton checkbox = (AbstractButton) e.getSource();
					if (checkbox.isSelected())
						boundingBoxActiva = true;
					else
						boundingBoxActiva = false;
				}
				reDesenhar();
			}
		}
		item.addActionListener(new ListenerItemMenu());
		return item;
	}

	public static void main(String[] args) {
		frame = new JFrame("Visualizador de Objectos 3D");
		barra = new JMenuBar();
		barra.add(criarMenuFicheiro());
		barra.add(criarMenuVer());

		frame.add(barra, BorderLayout.NORTH);
		GLCanvas canvas = new GLCanvas();
		canvas.addGLEventListener(new VisualizadorObj3D());
		canvas.setSize(600, 600);
		frame.add(canvas, BorderLayout.CENTER);
		painel = criarPainel();

		frame.add(painel, BorderLayout.SOUTH);
		frame.pack();
		frame.setMinimumSize(frame.getSize()); // Faz com que a janela não possa
												// ser reduzida.
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		canvas.requestFocusInWindow();
		frame.setVisible(true);
	}

	/**
	 * Desenha um cubo unitário.
	 * 
	 * @param gl
	 * @param glu
	 * @param glut
	 */
	private void desenhaCubo(GL gl, GLU glu, GLUT glut) {

		gl.glColor3f(0.0f, 0f, 1.0f);
		glut.glutWireCube(1.0f);
		gl.glFlush();
	}

	private void desenhaObjecto(GL gl) {

		if (boundingBoxActiva) {
			GLU glu = new GLU();
			GLUT glut = new GLUT();
			desenhaCubo(gl, glu, glut);
		}
		double maxDistancia = Math.max(
				Math.max(objecto.distanciaX, objecto.distanciaY),
				objecto.distanciaZ);

		gl.glScaled(1 / maxDistancia, 1 / maxDistancia, 1 / maxDistancia);
		ArrayList<Face> faces = objecto.faces;

		if (solidoActivo || texturaActiva) {
			gl.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_FILL);
			gl.glEnable(GL.GL_POLYGON_OFFSET_FILL);
			gl.glPolygonOffset(1, 1);
			// caso a textura esteja activa e existam vertices textura no
			// objecto
			if (texturaActiva && objecto.verticesTextura.size() > 0)
				aplicaTextura(gl);

			if (solidoActivo)
				gl.glColor3f(1f, 0f, 0f);
			else
				gl.glColor3f(1f, 1f, 1f);

			for (int i = 0; i < faces.size(); i++) {
				Vertex[] vertices = faces.get(i).vertices;
				Vertex[] verticesTextura = faces.get(i).verticesTextura;

				gl.glBegin(GL.GL_POLYGON);
				for (int j = 0; j < faces.get(i).tamanhoVertices; j++) {

					if (texturaActiva && verticesTextura[j] != null)
						gl.glTexCoord2d(verticesTextura[j].x,
								verticesTextura[j].y);

					gl.glVertex3d(vertices[j].x - objecto.centroX,
							vertices[j].y - objecto.centroY, vertices[j].z
									- objecto.centroZ);
				}
				gl.glEnd();
			}
			gl.glDisable(GL.GL_POLYGON_OFFSET_FILL);
			// desactivar textura
			gl.glDisable(GL.GL_TEXTURE_2D);
		}
		if (wireframeActivo) {

			for (int i = 0; i < faces.size(); i++) {
				Vertex[] vertices = faces.get(i).vertices;

				gl.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_LINE);
				gl.glColor3f(0f, 0f, 1.0f);
				gl.glBegin(GL.GL_POLYGON);
				for (int j = 0; j < faces.get(i).tamanhoVertices; j++) {

					gl.glVertex3d(vertices[j].x - objecto.centroX,
							vertices[j].y - objecto.centroY, vertices[j].z
									- objecto.centroZ);
				}
				gl.glEnd();
			}
		}

		gl.glFlush();
	}

	private void aplicaTextura(GL gl) {
		BufferedImage img = null;
		try {
			img = ImageIO.read(ficheiroTextura);
		} catch (IOException e) {
			e.printStackTrace();
		}
		WritableRaster raster = img.getRaster();
		int width = raster.getWidth();
		int height = raster.getHeight();
		DataBuffer buf = raster.getDataBuffer();
		switch (buf.getDataType()) {
		case DataBuffer.TYPE_BYTE:
			DataBufferByte bb = (DataBufferByte) buf;
			byte im[] = bb.getData();

			gl.glTexEnvi(GL.GL_TEXTURE_ENV, GL.GL_TEXTURE_ENV_MODE, GL.GL_DECAL);
			// Para usar a magnificação e redução linear. Melhor qualidade, mais
			// lento.
			gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER,
					GL.GL_LINEAR);
			gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER,
					GL.GL_LINEAR);

			gl.glTexImage2D(GL.GL_TEXTURE_2D, 0, GL.GL_RGB, width, height, 0,
					GL.GL_BGR, GL.GL_UNSIGNED_BYTE, ByteBuffer.wrap(im));

			gl.glEnable(GL.GL_TEXTURE_2D);

			break;
		case DataBuffer.TYPE_UNDEFINED:
			// report here!
			break;
		}
	}

	/**
	 * Aplica a projecção a seleccionada.
	 * 
	 * @param gl
	 */
	private void realizaProjeccao(GL gl) {
		switch (painelAbas.getSelectedIndex()) {
		case 0: // Ortogonal

			gl.glMultTransposeMatrixd(matrizOrtogonal, 0);
			if (planta.isSelected())
				gl.glRotated(90, 1, 0, 0);
			else if (alcadoDireito.isSelected())
				gl.glRotated(-90, 0, 1, 0);
			else if (alcadoEsquerdo.isSelected())
				gl.glRotated(90, 0, 1, 0);
			break;
		case 1: // Oblíqua
			if (gabinete.isSelected())
				gl.glMultTransposeMatrixd(matrizGabinete, 0);
			else if (cavaleira.isSelected())
				gl.glMultTransposeMatrixd(matrizCavaleira, 0);
			else if (ortogonal.isSelected())
				gl.glMultTransposeMatrixd(matrizOrtogonal, 0);
			break;
		case 2: // Axonométrica
			gl.glMultTransposeMatrixd(matrizOrtogonal, 0);

			gl.glRotated(teta, 0, 1, 0);
			gl.glRotated(gama, 1, 0, 0);
			break;
		case 3: // Perspectiva no plano Z=0

			double[] matrizPerspectivaZ0 = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, -1,
					0, 0, 0, -1 / centroPrespectivaD, 1 };
			gl.glMultTransposeMatrixd(matrizPerspectivaZ0, 0);
			break;
		default:
			break;
		}
	}

	/**
	 * Calcula o valor inicial do ângulo teta para a projecção axonométrica.
	 * 
	 * @return ângulo em graus.
	 */
	private static double calculaTetaInicial() {
		return Math
				.toDegrees(Math.atan(Math.sqrt(Math.tan(Math
						.toRadians(paxonometricaValorA))
						/ Math.tan(Math.toRadians(paxonometricaValorB))))
						- Math.PI / 2);
	}

	/**
	 * Calcula o valor inicial do ângulo gama para a projecção axonométrica.
	 * 
	 * @return ângulo em graus.
	 */
	private static double calculaGamaInicial() {
		return Math.toDegrees(Math.asin(Math.sqrt(Math.tan(Math
				.toRadians(paxonometricaValorA))
				* Math.tan(Math.toRadians(paxonometricaValorB)))));
	}

	private static GLAutoDrawable glDraw;
	private static JFrame frame;
	private static JMenuBar barra;
	private static JPanel painel;
	private static JTabbedPane painelAbas;
	private static JRadioButton alcadoPrincipal;
	private static JRadioButton alcadoEsquerdo;
	private static JRadioButton alcadoDireito;
	private static JRadioButton planta;
	private static JRadioButton cavaleira;
	private static JRadioButton gabinete;
	private static JRadioButton ortogonal;

	private double[] matrizCavaleira = { 1, 0,
			-1 * Math.cos(Math.toRadians(45)), 0, 0, 1,
			-1 * Math.sin(Math.toRadians(45)), 0, 0, 0, -1, 0, 0, 0, 0, 1 };

	private double[] matrizGabinete = { 1, 0,
			-0.5 * Math.cos(Math.toRadians(63.4)), 0, 0, 1,
			-0.5 * Math.sin(Math.toRadians(63.4)), 0, 0, 0, -1, 0, 0, 0, 0, 1 };

	private double[] matrizOrtogonal = { 1, 0,
			-0 * Math.cos(Math.toRadians(90)), 0, 0, 1,
			-0 * Math.sin(Math.toRadians(90)), 0, 0, 0, -1, 0, 0, 0, 0, 1 };

	// Valores para a trimetria
	private static double paxonometricaValorA = 24.46;
	private static double paxonometricaValorB = 17.0;
	private double height;
	private double width;
	// Angulos
	private static double teta;
	private static double gama;

	// Distancia em relacao ao plano de projecçao Z=0
	private static double centroPrespectivaD = 5.0;

	private static double zoomFactor = 1;
	private static final double zoomFactorStep = 0.1;

	// Para os objectos
	private static ObjectLoader objecto = null;
	private static File ficheiroTextura = null;

	private static boolean wireframeActivo;
	private static JMenuItem texturaCheckBox;
	private static boolean solidoActivo;
	private static boolean texturaActiva;
	private static boolean boundingBoxActiva;

}
