/*
 * Decompiled with CFR 0.152.
 */
package TruthTableSolver.gui;

import TruthTableSolver.gui.ButtonEditor;
import TruthTableSolver.gui.ButtonRenderer;
import TruthTableSolver.gui.RowHeaderRenderer;
import TruthTableSolver.solve.Solver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;

public class Gui
extends JFrame {
    public JPanel mainpanel;
    public static int number_of_terms;
    public static Vector<Integer> values;
    static String[] terms_names;
    static final JEditorPane editor_pane;
    static final JLabel status_bar;
    static JProgressBar progress_bar;
    static final String[] default_terms_names;
    int sum_of_products_or_product_of_sums;
    int one_sol_or_all_possible;
    Thread t = new Thread();

    public Gui() {
        super("Truth Table Solver 1.2 Beta");
        terms_names = default_terms_names;
        number_of_terms = 2;
        this.sum_of_products_or_product_of_sums = 0;
        this.one_sol_or_all_possible = 0;
        progress_bar = new JProgressBar();
        values = new Vector(number_of_terms);
        Gui.setAndClearValuesArray();
        this.mainpanel = new JPanel(new GridBagLayout());
        this.mainpanel.setOpaque(true);
        JScrollPane jScrollPane = new JScrollPane(this.mainpanel);
        this.add((Component)jScrollPane, "Center");
        this.setSize(750, 700);
        this.setMinimumSize(new Dimension(950, 700));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    public void createGui() throws IOException {
        AbstractTableModel abstractTableModel;
        AbstractTableModel abstractTableModel2;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic(67);
        jMenuItem.setToolTipText("Exit application");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic(70);
        JMenuItem jMenuItem2 = new JMenuItem("help");
        jMenuItem2.setMnemonic(72);
        jMenuItem2.setToolTipText("help");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPanel jPanel = new JPanel();
                jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(2, 2));
                JOptionPane.showMessageDialog(jPanel, "see \"HOW TO.txt\" in the program folder.");
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("About");
        jMenuItem3.setMnemonic(65);
        jMenuItem3.setToolTipText("About");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPanel jPanel = new JPanel();
                jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(2, 2));
                JOptionPane.showMessageDialog(jPanel, "                                 <Truth Table Solver 1.2 Beta>\n                             Copyright (C) <2011>  <Sherif Ahmed>\n\nTruth table Solver is a program that solves the truth table and output\nall possible minimized equations.\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\n\nreport any bug to <eng_sherif_ahmed@live.com>");
            }
        });
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        AbstractListModel abstractListModel = new AbstractListModel(){

            @Override
            public int getSize() {
                return number_of_terms;
            }

            @Override
            public Object getElementAt(int n) {
                return Character.toString((char)(65 + n));
            }
        };
        AbstractTableModel abstractTableModel3 = abstractTableModel2 = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return number_of_terms;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                Gui.terms_names[n] = (String)object;
                this.fireTableCellUpdated(n, n2);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return terms_names[n];
            }

            @Override
            public String getColumnName(int n) {
                return "Terms Names";
            }
        };
        final JTable jTable = new JTable(abstractTableModel3);
        jTable.setPreferredScrollableViewportSize(new Dimension(180, 160));
        JList jList = new JList(abstractListModel);
        jList.setFixedCellWidth(50);
        jList.setFixedCellHeight(jTable.getRowHeight() + jTable.getRowMargin() - 1);
        jList.setCellRenderer(new RowHeaderRenderer(jTable));
        final JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jTable.getTableHeader());
        jScrollPane.setRowHeaderView(jList);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        AbstractListModel abstractListModel2 = new AbstractListModel(){

            @Override
            public int getSize() {
                return (int)Math.pow(2.0, number_of_terms);
            }

            @Override
            public Object getElementAt(int n) {
                return n;
            }
        };
        AbstractTableModel abstractTableModel4 = abstractTableModel = new AbstractTableModel(){
            private Object[][] data;
            {
                this.data = Gui.this.getData(number_of_terms + 1);
            }

            @Override
            public int getColumnCount() {
                this.data = Gui.this.getData(number_of_terms + 1);
                return number_of_terms + 1;
            }

            @Override
            public int getRowCount() {
                return (int)Math.pow(2.0, number_of_terms);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                this.data[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return this.data[n][n2];
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return "FUNCTION";
                }
                return terms_names[n - 1];
            }
        };
        final JTable jTable2 = new JTable(abstractTableModel4);
        jTable2.getColumn("FUNCTION").setCellRenderer(new ButtonRenderer());
        jTable2.getColumn("FUNCTION").setCellEditor(new ButtonEditor(new JCheckBox()));
        final JList jList2 = new JList(abstractListModel2);
        jList2.setFixedCellWidth(50);
        jList2.setFixedCellHeight(jTable2.getRowHeight() + jTable2.getRowMargin() - 1);
        jList2.setCellRenderer(new RowHeaderRenderer(jTable2));
        final JScrollPane jScrollPane2 = new JScrollPane(jTable2);
        jScrollPane2.setCorner("UPPER_RIGHT_CORNER", jTable2.getTableHeader());
        jScrollPane2.setRowHeaderView(jList2);
        jScrollPane2.setBorder(BorderFactory.createEtchedBorder(0));
        jScrollPane2.setPreferredSize(new Dimension(690, 0));
        JButton jButton = new JButton("S    O    L    V    E");
        jButton.setForeground(Color.red);
        JButton jButton2 = new JButton("CLEAR VALUES");
        jButton2.setForeground(Color.blue);
        status_bar.setBorder(BorderFactory.createEtchedBorder(0));
        editor_pane.setEditable(false);
        editor_pane.setContentType("text/html");
        editor_pane.setText("<html><font color=blue><big>ZERO</big></font></html>");
        JScrollPane jScrollPane3 = new JScrollPane(editor_pane);
        jScrollPane3.setPreferredSize(new Dimension(0, 160));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(number_of_terms, 2, 16, 1);
        final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setName("number of terms");
        jSpinner.setFont(new Font("Dialog", 1, 15));
        JRadioButton jRadioButton = new JRadioButton("<html><font color=olive>Sum Of Products</font></html>");
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton("<html><font color=olive>Product Of Sums</font></html>");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JRadioButton jRadioButton3 = new JRadioButton("<html><font color=green>All possible solutions<br></br>(Occasionally slow)</font></html>");
        jRadioButton3.setSelected(true);
        JRadioButton jRadioButton4 = new JRadioButton("<html><font color=green>One solution<br></br>(fast)</font></html>");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton4);
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                number_of_terms = Integer.parseInt(jSpinner.getValue().toString());
                Gui.setAndClearValuesArray();
                jTable2.updateUI();
                abstractTableModel.fireTableStructureChanged();
                jTable2.getColumn("FUNCTION").setCellRenderer(new ButtonRenderer());
                jTable2.getColumn("FUNCTION").setCellEditor(new ButtonEditor(new JCheckBox()));
                jList2.updateUI();
                jScrollPane2.updateUI();
                jTable.updateUI();
            }
        });
        jTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Vector<Integer> vector = values;
                jTable2.updateUI();
                jScrollPane2.updateUI();
                abstractTableModel.fireTableStructureChanged();
                jTable2.getColumn("FUNCTION").setCellRenderer(new ButtonRenderer());
                jTable2.getColumn("FUNCTION").setCellEditor(new ButtonEditor(new JCheckBox()));
                jTable.updateUI();
                jScrollPane.updateUI();
                values = vector;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Vector<Integer> vector = values;
                jTable2.updateUI();
                abstractTableModel.fireTableStructureChanged();
                jTable2.getColumn("FUNCTION").setCellRenderer(new ButtonRenderer());
                jTable2.getColumn("FUNCTION").setCellEditor(new ButtonEditor(new JCheckBox()));
                jScrollPane2.updateUI();
                jTable.updateUI();
                jScrollPane.updateUI();
                values = vector;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.terms_names[0] = "A";
                Gui.terms_names[1] = "B";
                Gui.terms_names[2] = "C";
                Gui.terms_names[3] = "D";
                Gui.terms_names[4] = "E";
                Gui.terms_names[5] = "F";
                Gui.terms_names[6] = "G";
                Gui.terms_names[7] = "H";
                Gui.terms_names[8] = "I";
                Gui.terms_names[9] = "J";
                Gui.terms_names[10] = "K";
                Gui.terms_names[11] = "L";
                Gui.terms_names[12] = "M";
                Gui.terms_names[13] = "N";
                Gui.terms_names[14] = "O";
                Gui.terms_names[15] = "P";
                Gui.setAndClearValuesArray();
                abstractTableModel.fireTableStructureChanged();
                abstractTableModel2.fireTableStructureChanged();
                jTable2.getColumn("FUNCTION").setCellRenderer(new ButtonRenderer());
                jTable2.getColumn("FUNCTION").setCellEditor(new ButtonEditor(new JCheckBox()));
            }
        });
        jButton.addMouseListener(new MouseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int[] nArray = new int[(int)Math.pow(2.0, number_of_terms)];
                String[] stringArray = new String[number_of_terms];
                Solver solver = new Solver(nArray, stringArray, Gui.this.sum_of_products_or_product_of_sums, Gui.this.one_sol_or_all_possible);
                if (Gui.this.t.isAlive()) {
                    Gui.this.t.interrupt();
                    try {
                        Gui.this.t.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Gui.this.t = null;
                }
                Gui.this.t = new Thread(solver);
                System.arraycopy(terms_names, 0, stringArray, 0, number_of_terms);
                for (int i = 0; i < (int)Math.pow(2.0, number_of_terms); ++i) {
                    nArray[i] = values.get(i);
                }
                try {
                    Gui.this.t.start();
                    Gui.this.t.setPriority(9);
                    Thread.currentThread().setPriority(1);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    JPanel jPanel = new JPanel();
                    jPanel = new JPanel();
                    jPanel.setLayout(new GridLayout(2, 2));
                    JOptionPane.showMessageDialog(jPanel, "    " + outOfMemoryError.getMessage() + " ERROR" + (Gui.this.one_sol_or_all_possible == 0 ? "\n   you should use the \"one solution\" option" : ""), "ERROR", 0);
                }
                catch (Error error) {
                    JPanel jPanel = new JPanel();
                    jPanel = new JPanel();
                    jPanel.setLayout(new GridLayout(2, 2));
                    JOptionPane.showMessageDialog(jPanel, "    " + error.getMessage() + " ERROR ", "ERROR", 0);
                }
                finally {
                    Gui.setStatusBar("Done");
                    Gui.setProgressBar(false);
                    solver = null;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        editor_pane.addInputMethodListener(null);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.sum_of_products_or_product_of_sums = 0;
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.sum_of_products_or_product_of_sums = 1;
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.one_sol_or_all_possible = 0;
            }
        });
        jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.one_sol_or_all_possible = 1;
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridheight = 11;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.mainpanel.add((Component)jScrollPane2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.weighty = 0.5;
        gridBagConstraints2.anchor = 17;
        this.mainpanel.add((Component)jScrollPane, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.weightx = 0.1;
        gridBagConstraints3.weighty = 0.5;
        gridBagConstraints3.anchor = 24;
        this.mainpanel.add((Component)jSpinner, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.weightx = 0.1;
        gridBagConstraints4.weighty = 0.5;
        gridBagConstraints4.anchor = 26;
        this.mainpanel.add((Component)new JLabel("<html><font color=green>Number Of Terms</font></html>"), gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 10;
        gridBagConstraints5.weightx = 0.1;
        gridBagConstraints5.weighty = 0.5;
        gridBagConstraints5.anchor = 13;
        this.mainpanel.add((Component)jButton, gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 9;
        gridBagConstraints6.weightx = 0.1;
        gridBagConstraints6.weighty = 0.5;
        gridBagConstraints6.anchor = 13;
        this.mainpanel.add((Component)jButton2, gridBagConstraints6);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 11;
        gridBagConstraints7.weightx = 0.5;
        gridBagConstraints7.weighty = 0.5;
        gridBagConstraints7.gridwidth = 3;
        this.mainpanel.add((Component)jScrollPane3, gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 12;
        gridBagConstraints8.gridwidth = 2;
        gridBagConstraints8.gridheight = 3;
        this.mainpanel.add((Component)status_bar, gridBagConstraints8);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridy = 5;
        gridBagConstraints9.weightx = 0.1;
        gridBagConstraints9.weighty = 0.5;
        gridBagConstraints9.anchor = 25;
        this.mainpanel.add((Component)jRadioButton, gridBagConstraints9);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 6;
        gridBagConstraints10.weightx = 0.1;
        gridBagConstraints10.weighty = 0.5;
        gridBagConstraints10.anchor = 23;
        this.mainpanel.add((Component)jRadioButton2, gridBagConstraints10);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 7;
        gridBagConstraints11.weightx = 0.1;
        gridBagConstraints11.weighty = 0.5;
        gridBagConstraints11.anchor = 25;
        this.mainpanel.add((Component)jRadioButton3, gridBagConstraints11);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.gridy = 8;
        gridBagConstraints12.weightx = 0.1;
        gridBagConstraints12.weighty = 0.5;
        gridBagConstraints12.anchor = 23;
        this.mainpanel.add((Component)jRadioButton4, gridBagConstraints12);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 12;
        gridBagConstraints13.weightx = 0.1;
        gridBagConstraints13.weighty = 0.5;
        gridBagConstraints13.anchor = 13;
        this.mainpanel.add((Component)progress_bar, gridBagConstraints13);
    }

    String[] getColumnNames(int n, AbstractTableModel abstractTableModel) {
        String[] stringArray = new String[n];
        stringArray[0] = "FUNCTION";
        for (int i = 1; i < n; ++i) {
            stringArray[i] = abstractTableModel.getValueAt(i - 1, 0).toString();
        }
        return stringArray;
    }

    Object[][] getData(int n) {
        int n2;
        int n3 = n;
        int n4 = (int)Math.pow(2.0, n3 - 1);
        Object[][] objectArray = new Object[n4][n3];
        for (n2 = 0; n2 < n4; ++n2) {
            if (values.get(n2) == 0) {
                objectArray[n2][0] = "<html><font color=green>0</font></html>";
                continue;
            }
            if (values.get(n2) == 1) {
                objectArray[n2][0] = "<html><font color=red>1</font></html>";
                continue;
            }
            if (values.get(n2) != 2) continue;
            objectArray[n2][0] = "<html><font color=blue>d</font></html>";
        }
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            for (int j = n3 - 1; j > 0; --j) {
                objectArray[i][j] = n2 % 2;
                n2 /= 2;
            }
        }
        return objectArray;
    }

    public static void setAndClearValuesArray() {
        values = new Vector();
        for (int i = 0; i < (int)Math.pow(2.0, number_of_terms); ++i) {
            values.add(0);
        }
    }

    public static void setAnswer(String string) {
        editor_pane.setText(string);
    }

    public static void setStatusBar(String string) {
        status_bar.setText(string);
    }

    public static void setProgressBar(boolean bl) {
        progress_bar.setIndeterminate(bl);
    }

    static {
        editor_pane = new JEditorPane();
        status_bar = new JLabel();
        default_terms_names = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P"};
    }
}

