/*
 * Decompiled with CFR 0.152.
 */
package TruthTableSolver.solve;

import TruthTableSolver.solve.GenerateNumbersOrderedByNumberOfOnes;
import TruthTableSolver.solve.PrimeImplicantsChartRow;
import java.util.Vector;

public class PrimeImplicantsChartTable {
    Vector<PrimeImplicantsChartRow> table;
    Vector<PrimeImplicantsChartRow> non_essential_table = new Vector();
    Vector<Vector<Integer>> minimume_compination_of_non_essential_table = new Vector();
    Vector<Integer> essential_primes_indexs = new Vector();
    int number_of_rows;
    int number_of_columns;
    int[] satisfied_columns_by_essintial_primes;

    PrimeImplicantsChartTable(int[] nArray, Vector<Integer> vector, Vector<Integer> vector2, int n) {
        this.number_of_rows = vector.size();
        this.table = new Vector();
        Vector<Integer> vector3 = this.onesPositionsInTable(nArray);
        this.number_of_columns = vector3.size();
        for (int i = 0; i < this.number_of_rows; ++i) {
            this.addRow(this.createPrimeChartRow(this.calPossibleValues(vector.get(i), vector2.get(i)), vector3), i);
        }
        this.calculateALL(n);
    }

    private Vector<Integer> onesPositionsInTable(int[] nArray) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            vector.add(i);
        }
        return vector;
    }

    private int[] createPrimeChartRow(Vector<Integer> vector, Vector<Integer> vector2) {
        int n = vector2.size();
        int[] nArray = new int[n];
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                if (vector2.get(i).intValue() != vector.get(j).intValue()) continue;
                nArray[i] = 1;
                continue block0;
            }
        }
        return nArray;
    }

    private Vector<Integer> calPossibleValues(int n, int n2) {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = this.calNumberAndPositionsOfOnes(n2);
        int n3 = vector2.size();
        int n4 = (int)Math.pow(2.0, n3);
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                n5 += this.decimalToBinary(i, j) * (int)Math.pow(2.0, vector2.get(j).intValue());
            }
            vector.add(n + n5);
            n5 = 0;
        }
        return vector;
    }

    private Vector<Integer> calNumberAndPositionsOfOnes(int n) {
        int n2 = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        for (int i = (int)Math.pow(2.0, n2); i != 0; i /= 2) {
            if (n >= i) {
                n -= i;
                vector.add(n2 - n3);
            }
            ++n3;
        }
        return vector;
    }

    private void calculateALL(int n) {
        this.createEssentialPrimesIndexs();
        if (this.checkNonEssentialExist()) {
            if (n == 0) {
                this.createMinimumeCompinationOfNonEssentialTable();
            } else {
                this.createOneMinimumeCompinationOfNonEssentialTable();
            }
        }
    }

    private boolean checkNonEssentialExist() {
        boolean bl = false;
        for (int i = 0; i < this.satisfied_columns_by_essintial_primes.length; ++i) {
            if (this.satisfied_columns_by_essintial_primes[i] != 0) continue;
            bl = true;
        }
        return bl && this.non_essential_table.size() > 0;
    }

    private void createEssentialPrimesIndexs() throws OutOfMemoryError {
        int n;
        int n2;
        int n3 = 0;
        int n4 = -1;
        int[] nArray = new int[this.number_of_rows];
        this.satisfied_columns_by_essintial_primes = new int[this.number_of_columns];
        for (n2 = 0; n2 < this.number_of_columns; ++n2) {
            for (n = 0; n < this.number_of_rows; ++n) {
                if (this.table.get(n).getCell(n2) != 1) continue;
                ++n3;
                n4 = n;
            }
            if (n3 == 1) {
                nArray[n4] = 1;
                this.satisfied_columns_by_essintial_primes[n2] = 1;
            }
            n3 = 0;
        }
        for (n2 = 0; n2 < this.number_of_rows; ++n2) {
            if (nArray[n2] == 0) {
                this.non_essential_table.add(this.table.get(n2));
                continue;
            }
            this.essential_primes_indexs.add(n2);
        }
        for (n2 = 0; n2 < this.essential_primes_indexs.size(); ++n2) {
            for (n = 0; n < this.number_of_columns; ++n) {
                if (this.table.get(this.essential_primes_indexs.get(n2)).getCell(n) != 1) continue;
                this.satisfied_columns_by_essintial_primes[n] = 1;
            }
        }
    }

    private void createMinimumeCompinationOfNonEssentialTable() {
        int[] nArray = new int[this.number_of_columns];
        int n = this.non_essential_table.size();
        GenerateNumbersOrderedByNumberOfOnes generateNumbersOrderedByNumberOfOnes = new GenerateNumbersOrderedByNumberOfOnes(this.non_essential_table.size());
        Vector<Object> vector = new Vector();
        boolean bl = false;
        Vector<Integer> vector2 = new Vector<Integer>();
        nArray = this.satisfied_columns_by_essintial_primes;
        for (int i = 1; i < this.non_essential_table.size(); ++i) {
            vector = generateNumbersOrderedByNumberOfOnes.getNumbers();
            for (int j = 0; j < vector.size(); ++j) {
                for (int k = 0; k < this.non_essential_table.size(); ++k) {
                    if (this.decimalToBinary((Long)vector.get(j), k) == 1) {
                        nArray = this.combine(this.non_essential_table.get(k).getRow(), nArray);
                        vector2.add(this.non_essential_table.get(k).getRowIndex());
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    return;
                }
                if (this.checkAnswer(nArray)) {
                    this.minimume_compination_of_non_essential_table.add(vector2);
                    bl = true;
                }
                vector2 = new Vector();
                nArray = this.satisfied_columns_by_essintial_primes;
            }
            if (bl) break;
        }
    }

    private void createOneMinimumeCompinationOfNonEssentialTable() {
        int n;
        Vector<PrimeImplicantsChartRow> vector = this.non_essential_table;
        Vector<Integer> vector2 = new Vector<Integer>();
        int n2 = 0;
        PrimeImplicantsChartRow primeImplicantsChartRow = new PrimeImplicantsChartRow();
        for (n = 0; n < vector.size(); ++n) {
            vector.get(n).setRow(this.combineNotFirst(this.satisfied_columns_by_essintial_primes, vector.get(n).getRow()), vector.get(n).getRowIndex());
        }
        while (vector.size() > 0) {
            n2 = this.calculateRowWithMaximumNumberOfOnes(vector);
            primeImplicantsChartRow = vector.get(n2);
            vector2.add(primeImplicantsChartRow.getRowIndex());
            vector.remove(n2);
            for (n = 0; n < vector.size(); ++n) {
                vector.get(n).setRow(this.combineNotFirst(primeImplicantsChartRow.getRow(), vector.get(n).getRow()), vector.get(n).getRowIndex());
                if (vector.get(n).getNumberOfOnesInRow() != 0) continue;
                vector.remove(n);
                --n;
            }
        }
        this.minimume_compination_of_non_essential_table.add(vector2);
    }

    private int calculateRowWithMaximumNumberOfOnes(Vector<PrimeImplicantsChartRow> vector) {
        int n = vector.get(0).getNumberOfOnesInRow();
        int n2 = 0;
        for (int i = 1; i < vector.size(); ++i) {
            if (vector.get(i).getNumberOfOnesInRow() <= n) continue;
            n = vector.get(i).getNumberOfOnesInRow();
            n2 = i;
        }
        return n2;
    }

    private int decimalToBinary(long l, int n) {
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            n2 = (int)(l % 2L);
            l /= 2L;
        }
        return n2;
    }

    private int[] combine(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i] != 1 && nArray2[i] != 1) continue;
            nArray3[i] = 1;
        }
        return nArray3;
    }

    private int[] combineNotFirst(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[i] == 1 ? 0 : nArray2[i];
        }
        return nArray3;
    }

    private boolean checkAnswer(int[] nArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) continue;
            bl = false;
        }
        return bl;
    }

    void addRow(int[] nArray, int n) {
        PrimeImplicantsChartRow primeImplicantsChartRow = new PrimeImplicantsChartRow();
        primeImplicantsChartRow.setRow(nArray, n);
        this.table.add(primeImplicantsChartRow);
    }

    int[] getRow(int n) {
        return this.table.get(n).getRow();
    }

    Vector<Integer> getEssentialPrimesIndexs() {
        return this.essential_primes_indexs;
    }

    Vector<Vector<Integer>> getMinimumeCompinationOfNonEssentialTable() {
        return this.minimume_compination_of_non_essential_table;
    }
}

