/*
 * Decompiled with CFR 0.152.
 */
package TruthTableSolver.solve;

import TruthTableSolver.gui.Gui;
import TruthTableSolver.solve.Format;
import TruthTableSolver.solve.Node;
import TruthTableSolver.solve.Tlist;

public class Solver
implements Runnable {
    private Tlist table = new Tlist();
    private int[] v;
    private String[] terms_names;
    private int sum_of_products_or_product_of_sums;
    private int one_sol_or_all_possible;
    private String solution;

    public Solver(int[] nArray, String[] stringArray, int n, int n2) {
        this.v = nArray;
        this.terms_names = stringArray;
        this.sum_of_products_or_product_of_sums = n;
        this.one_sol_or_all_possible = n2;
    }

    public void Solve() {
        Format format = new Format();
        boolean bl = this.checkNoOnes();
        boolean bl2 = this.checkNoZeros();
        if (bl && bl2) {
            this.solution = "<html><font color=blue><big>ONE OR ZERO</big></font></html>";
        } else if (bl2) {
            this.solution = "<html><font color=blue><big>ONE</big></font></html>";
        } else if (bl) {
            this.solution = "<html><font color=blue><big>ZERO</big></font></html>";
        } else {
            this.fillTable();
            Tlist tlist = this.minimize(this.table);
            tlist = this.smoosh(tlist);
            this.solution = format.formatOutput(this.v, tlist.getValues(), tlist.getSubs(), this.terms_names, this.sum_of_products_or_product_of_sums, this.one_sol_or_all_possible);
        }
    }

    private void fillTable() {
        if (this.sum_of_products_or_product_of_sums == 1) {
            this.v = this.inverse(this.v);
        }
        for (int i = 0; i < this.v.length; ++i) {
            if (this.v[i] == 0) continue;
            this.table.addNode(i);
        }
    }

    private int[] inverse(int[] nArray) {
        int[] nArray2 = nArray;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) {
                nArray2[i] = 1;
                continue;
            }
            if (nArray2[i] != 1) continue;
            nArray2[i] = 0;
        }
        return nArray2;
    }

    private boolean checkNoOnes() {
        boolean bl = true;
        for (int i = 0; i < this.v.length; ++i) {
            if (this.v[i] != 1) continue;
            bl = false;
        }
        return bl;
    }

    private boolean checkNoZeros() {
        boolean bl = true;
        for (int i = 0; i < this.v.length; ++i) {
            if (this.v[i] != 0) continue;
            bl = false;
        }
        return bl;
    }

    private Tlist minimize(Tlist tlist) {
        Node node = new Node();
        Node node2 = new Node();
        Tlist tlist2 = new Tlist();
        boolean bl = true;
        int n = 0;
        for (node = tlist.getHead(); node != null; node = node.getNext()) {
            for (node2 = node.getNext(); node2 != null; node2 = node2.getNext()) {
                n = node2.getValue() - node.getValue();
                if (!this.checkVaryByOneDigite(node, node2)) continue;
                if (tlist2.getHead() == null || tlist2.getTail().getValue() != node.getValue() || tlist2.getTail().getSub() != node.getSub() + n) {
                    tlist2.addNode(node.getValue(), node.getSub() + n, false);
                }
                bl = false;
                node.setMark(true);
                node2.setMark(true);
            }
            if (node.getMark()) continue;
            tlist2.addNode(node.getValue(), node.getSub(), false);
        }
        if (bl) {
            return tlist2;
        }
        return this.minimize(tlist2);
    }

    private boolean checkVaryByOneDigite(Node node, Node node2) {
        int n = node.getValue();
        int n2 = node2.getValue();
        int n3 = node.getSub();
        int n4 = node2.getSub();
        int n5 = Math.abs(n - n2);
        if (n5 == 0 || n3 != n4) {
            return false;
        }
        if (n5 == 1) {
            return n % 2 == 0;
        }
        if (this.checkPowerOfTwo(n5)) {
            return n / n5 % 2 == 0;
        }
        return false;
    }

    private boolean checkPowerOfTwo(int n) {
        double d = Math.log(n) / Math.log(2.0);
        return Math.ceil(d) == Math.floor(d) && n != 0;
    }

    private Tlist smoosh(Tlist tlist) {
        Tlist tlist2 = new Tlist();
        boolean bl = true;
        for (Node node = tlist.getHead(); node != null; node = node.getNext()) {
            for (Node node2 = node.getNext(); node2 != null; node2 = node2.getNext()) {
                if (!this.equal(node, node2)) continue;
                bl = false;
            }
            if (bl) {
                tlist2.addNode(node.getValue(), node.getSub(), node.getMark());
            }
            bl = true;
        }
        return tlist2;
    }

    private boolean equal(Node node, Node node2) {
        return node.getValue() == node2.getValue() && node.getSub() == node2.getSub();
    }

    @Override
    public void run() {
        Gui.setAnswer("Solving.......");
        Gui.setStatusBar("Solving......Please Wait(\"This may take long time\").");
        Gui.setProgressBar(true);
        this.Solve();
        Gui.setAnswer(this.solution);
        Gui.setStatusBar("Done");
        Gui.setProgressBar(false);
    }

    public String getSolution() {
        return this.solution;
    }
}

