/*
 * Decompiled with CFR 0.152.
 */
package TruthTableSolver.cmdIn;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Prompt {
    private int[] values;
    private int number_of_terms;
    private String[] terms_names;
    private int sum_of_products_or_product_of_sums;
    private int all_possible_or_one_sol;

    public void promptUser() throws Exception {
        this.opening();
        this.number_of_terms = this.promptNumberOfTerms();
        this.terms_names = new String[this.number_of_terms];
        this.values = new int[(int)Math.pow(2.0, this.number_of_terms)];
        this.sum_of_products_or_product_of_sums = 0;
        this.promptTermsNames();
        this.promptValues();
        this.promptSumOfProductsOrProductOfSums();
        this.promptOneAllPossibleSolutionsOrOneSolution();
    }

    void opening() {
        System.out.println("*********************************************************\n*      ###   #   # #  ###  # #    ###   #   ##   #   ## *\n*       #   # #  # #   #   # #     #   # #  # #  #   #  *\n*       #   ##   # #   #   ###     #   ###  ##   #   ## *\n*       #   # #  # #   #   # #     #   # #  # #  #   #  *\n*       #   # #  ###   #   # #     #   # #  ##   ##  ## *\n*                                                       *\n*                                                       *\n*         ##  ###  #   # #  ##   #                      *\n*         #   # #  #   # #  #   # #                     *\n*         ##  # #  #   # #  ##  ##    1.2 Beta          *\n*          #  # #  #   # #  #   # #                     *\n*         ##  ###  ##   #   ##  # #   By : Sherif Ahmed *\n*********************************************************\n\nThis program solves the truth table and output all the possible minimized  \nequations.\n");
    }

    private int promptNumberOfTerms() throws Exception {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("enter the number of terms : ");
        try {
            n = Integer.parseInt(bufferedReader.readLine());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("\nerror : enter a positive integer.\n");
            n = this.promptNumberOfTerms();
        }
        if (n <= 0) {
            System.out.println("\nerror : enter a positive integer.\n");
            n = this.promptNumberOfTerms();
        }
        return n;
    }

    private void promptTermsNames() throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        for (int i = 0; i < this.terms_names.length; ++i) {
            System.out.print("enter name of term[" + (i + 1) + "] : ");
            this.terms_names[i] = bufferedReader.readLine();
        }
    }

    private void promptValues() throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        boolean bl = false;
        System.out.println();
        for (int i = 0; i < this.values.length; ++i) {
            System.out.print("enter the value[" + i + "] : ");
            String string = bufferedReader.readLine();
            if (string.equals("0")) {
                this.values[i] = 0;
                continue;
            }
            if (string.equals("1")) {
                this.values[i] = 1;
                continue;
            }
            if (string.equals("d")) {
                this.values[i] = 2;
                continue;
            }
            System.out.println("\nerror : enter 0 or 1 or d.\n");
            --i;
        }
    }

    private void promptSumOfProductsOrProductOfSums() throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        do {
            System.out.print("enter 1 for sum of products or 2 for product of sums : ");
            string = bufferedReader.readLine();
            if (string.equals("1")) {
                this.sum_of_products_or_product_of_sums = 0;
                continue;
            }
            if (string.equals("2")) {
                this.sum_of_products_or_product_of_sums = 1;
                continue;
            }
            System.out.println("\nerror : enter 1 for sum of products or 2 for product of sums.\n");
        } while (!string.equals("1") && !string.equals("2"));
    }

    private void promptOneAllPossibleSolutionsOrOneSolution() throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        do {
            System.out.print("enter 1 for (all possible solutions[occasionaly slow]) or \n2 (one solution only[fast]): ");
            string = bufferedReader.readLine();
            if (string.equals("1")) {
                this.all_possible_or_one_sol = 0;
                continue;
            }
            if (string.equals("2")) {
                this.all_possible_or_one_sol = 1;
                continue;
            }
            System.out.println("\nerror : enter 1 for (all possible solutions[occasionaly slow]) or 2 (one solution only[fast]) .\n");
        } while (!string.equals("1") && !string.equals("2"));
    }

    public int[] getValues() {
        return this.values;
    }

    public int getNumberOfTerms() {
        return this.number_of_terms;
    }

    public String[] getTermsNames() {
        return this.terms_names;
    }

    public int getSumOfProductsOrProductOfSums() {
        return this.sum_of_products_or_product_of_sums;
    }

    public int getOneAllPossibleSolutionsOrOneSolution() {
        return this.all_possible_or_one_sol;
    }
}

