/**
 * 
 */

/**
 * @author ALC
 *
 */
// A classe ArvoreNatal implementa a arvore de Natal, que deve ter uma coleccao
// de ate 20 caixas surpresa
public class ArvoreNatal {
	// Constantes

	// Variaveis de instancia
	private int actual; // usada no iterador ja implementado
	private int numeroCaixasSurpresa;
	private CaixaSurpresa[] caixas;

	// Cria uma arvore de natal, que comeca sem caixas surpresa.
	public ArvoreNatal() {
		caixas = new CaixaSurpresa[0];
		actual = -1; // usada no iterador ja implementado
		numeroCaixasSurpresa = 0;
	}

	// Metodos privados, caso necessite
	private int posicaoDe(String nome) {
		boolean loop = true;
		int pos = -1;
		while (pos < numeroCaixasSurpresa && loop) {
			if (caixas[pos].daNomeDono().equals(nome)) {
				loop = false;
			} else
				pos++;
		}
		return pos;
	}

	// Testa se existe alguma caixa supresa para a pessoa com o nome passado
	// por argumento. Pre: nome!=NULL
	public boolean temCaixaSurpresa(String nome) {
		boolean existe = false;
		if (posicaoDe(nome) != -1)
			existe = true;
		else
			existe = false;
		return existe;
	}

	// Devolve o numero de prendas na caixa surpresa da pessoa cujo nome e
	// passado como argumento. Pre: nome!=NULL && temCaixaSurpresa(nome)
	public int numeroPrendasCaixaSurpresa(String nome) {
		int pos = posicaoDe(nome);
		return caixas[pos].numeroPrendas();
	}

	// Adiciona uma nova prenda na caixa da pessoa cujo nome e passado como
	// argumento. Se essa pessoa ainda nao tiver uma caixa, sera criada uma no
	// momento, usando, alem do nome, a idade da pessoa e a descrio da
	// prenda. Note que a coleccao deve estar organizada por ordem crescente
	// de idade. Em caso de empate de idades, as caixas mais antigas
	// aparecem primeiro. Caso tenha de se criar uma caixa surpresa mas o
	// limite (20 caixas) ja tenha sido atingido, o metodo no faz nada.
	// Pre: nome!=NULL && idade > 0 && desc!=NULL
	public void adicionaPrenda(String nome, int idade, String desc) {
		if (temCaixaSurpresa(nome)) {
			int pos = posicaoDe(nome);
			caixas[pos].adicionaPrenda(desc);
		} else if (numeroCaixasSurpresa < 20) {
			boolean loop = true;
			int pos = 0;
			while (loop) {
				if (caixas[pos].daIdadeDono() <= idade)
					pos++;
				else {
					for (int p = numeroCaixasSurpresa; p > pos; p--) {
						caixas[p] = caixas[p - 1];
					}
					caixas[pos].adicionaPrenda(desc);
				}
			}
		}
	}

	// Semelhante ao anterior, mas adiciona a prenda numa posicao pos.
	// Pre: nome!=NULL && temCaixaSurpresa(nome) && pos>0 &&
	// pos <= numeroPrendasCaixaSurpresa(nome)
	public void adicionaPrenda(String nome, String desc, int pos) {
		int p = posicaoDe(nome);
		caixas[p].adicionaPrenda(desc, pos);
	}

	// Retira a caixa da pessoa com o nome passado como argumento. As prendas
	// da caixa a eliminar sao distribuidas de forma equilibrada pelas caixas
	// existentes da mesma faixa etaria. Caso nao existam mais caixas dessa
	// faixa etaria, nao se faz nenhuma distribuicao de prendas. Caso
	// nao seja possivel distribuir o mesmo numero de prendas por todas as
	// caixas, deve-se garantir que a diferenca entre o numero maximo de
	// prendas atribuidas a caixas da mesma faixa etaria e o numero minimo de
	// prendas atribuidas a caixas dessa faixa no excede 1. // Pre: nome != NULL &&
	// temCaixaSurpresa(nome)
	public void retiraCaixaSurpresa(String nome) {
		int pos = posicaoDe(nome);
		int etaria = caixas[pos].daEtariaDono();
		caixas[pos].iniciaIterador();
		int p = 0;
		while (caixas[pos].temSeguinte()) {
			if (caixas[p].daEtariaDono() == etaria && p != pos) {
				Prenda prenda = caixas[pos].seguinte();
				caixas[p].adicionaPrenda(prenda.daDescricao());
				p++;
			} else if (p == pos || caixas[p].daEtariaDono() != etaria && p < numeroCaixasSurpresa - 1)
				p++;
			else if (p == numeroCaixasSurpresa - 1)
				p = 0;
		}
		for (int i = pos; i < numeroCaixasSurpresa; i++) {
			caixas[i] = caixas[i + 1];
		}
		numeroCaixasSurpresa--;
	}

	// Iterador de caixas surpresa - assuma que esta feito e use se e onde
	// necessitar neste teste. O iterador itera os elementos organizados por
	// idade crescente e, em caso de empate, por antiguidade das caixas.
	public void iniciaIterador() {
		actual = 0;
	} // inicializa o iterador

	public boolean temSeguinte() {
		return true;
	} // testa se existem elementos a visitor

	public CaixaSurpresa seguinte() {
		return caixas[actual++];
	} // visita elemento seguinte
}
