/**
 * 
 */

/**
 * @author ALC
 *
 */
// Esta classe representa objectos do tipo caixa supresa
public class CaixaSurpresa {
	public static final int PRENDAS_PREVISTAS = 10;
	private Pessoa dono; // O destinatario da caixa surpresa
	private Prenda[] prendas; // O conjunto de prendas na caixa surpresa
	private int contaPrendas; // O numero de prendas na caixa
	private int actual; // A posicao actual do iterador de prendas

	// Cria uma nova caixa supresa, dado o nome do destinatario da caixa
	// surpresa, a sua idade e uma descricao da primeira prenda a colocar
	// na caixa. Pre: nome!=NULL && idade >= 0 && desc != NULL

	public CaixaSurpresa(String nome, int idade, String desc) {
		prendas = new Prenda[PRENDAS_PREVISTAS];
		prendas[0] = new Prenda(desc);
		contaPrendas = 1;
		dono = new Pessoa(nome, idade);
		actual = -1;
	}
	// Mtodos privados, caso necessite

	// Devolve o numero de prendas na caixa
	public int numeroPrendas() {
		return contaPrendas;
	}

	// Acrescenta uma prenda a caixa, dada a descricao dessa prenda. Se
	// necessario, aumenta a sua capacidade da caixa. Pre: desc!=NULL
	public void adicionaPrenda(String desc) {
		if (contaPrendas == PRENDAS_PREVISTAS) {
			Prenda[] aux = new Prenda[numeroPrendas() + 1];
			for (int pos = 0; pos < numeroPrendas(); pos++)
				aux[pos] = prendas[pos];
			prendas = aux;
		}
		prendas[contaPrendas++] = new Prenda(desc);
	}

	// Adiciona a prenda descrita no parametro desc na posicao pos da caixa de
	// prendas. Pre: desc!= NULL && pos>0 && pos <= numeroPrendas()
	public void adicionaPrenda(String desc, int pos) {
		for (int position = numeroPrendas() - 1; position > pos - 1; position--)
			prendas[position] = prendas[position - 1];
		prendas[pos - 1] = new Prenda(desc);
		contaPrendas++;
	}

	// Devolve o nome do dono da caixa surpresa.
	public String daNomeDono() {
		return dono.daNome();
	}

	// Devolve a idade do dono da caixa surpresa.
	public int daIdadeDono() {
		return dono.daIdade();
	}

	// Devolve a faixa etaria do dono da caixa surpresa.
	public int daEtariaDono() {
		return dono.daEtaria();
	}

	// Inicializa o iterador de prendas da caixa surpresa.
	public void iniciaIterador() {
		actual = 0;
	}

	// Testa se existem mais prendas a visitar com o iterador de prendas da caixa
	// surpresa, retornando true caso existam, ou false, caso contrario.
	public boolean temSeguinte() {
		return actual >= 0 && actual < contaPrendas;
	}

	// Devolve a proxima Prenda a iterar na caixa surpresa.
	public Prenda seguinte() {
		return prendas[actual++];
	}
}
